/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import java.lang.reflect.Constructor;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.common.DrillScanRelBase;
import org.apache.drill.exec.planner.index.IndexDiscover;
import org.apache.drill.exec.planner.index.IndexDiscoverBase;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexDiscoverFactory {
    static final Logger logger = LoggerFactory.getLogger(IndexDiscoverFactory.class);
    static final String INDEX_DISCOVER_CLASS_KEY = "index.discoverClass";
    static final String INDEX_DISCOVER_CONFIG_KEY = "index.meta";

    public static IndexDiscover getIndexDiscover(StoragePluginConfig config, GroupScan inScan, RelNode scanRel, Class<? extends IndexDiscover> targetIndexDiscoverClass) {
        Class<IndexDiscover> discoverClass = targetIndexDiscoverClass;
        try {
            String discoverClassName;
            if (config != null && (discoverClassName = config.getValue(INDEX_DISCOVER_CLASS_KEY)) != null && discoverClassName != "") {
                discoverClass = Class.forName(discoverClassName);
            }
        }
        catch (Exception e) {
            logger.error("Could not find configured IndexDiscover class {}", (Throwable)e);
        }
        try {
            Constructor<? extends IndexDiscoverBase> constructor = IndexDiscoverFactory.getConstructor(discoverClass, scanRel);
            IndexDiscoverBase idxDiscover = constructor.newInstance(inScan, scanRel);
            if (targetIndexDiscoverClass == null || discoverClass != targetIndexDiscoverClass) {
                // empty if block
            }
            return idxDiscover;
        }
        catch (Exception e) {
            logger.error("Could not construct {}", (Object)discoverClass.getName(), (Object)e);
            return null;
        }
    }

    private static Constructor<? extends IndexDiscoverBase> getConstructor(Class discoverClass, RelNode scanRel) throws Exception {
        if (scanRel instanceof DrillScanRelBase) {
            return discoverClass.getConstructor(GroupScan.class, DrillScanRelBase.class);
        }
        return discoverClass.getConstructor(GroupScan.class, ScanPrel.class);
    }
}

