/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import java.util.Collection;
import java.util.HashSet;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.exec.physical.base.AbstractDbGroupScan;
import org.apache.drill.exec.planner.common.DrillScanRelBase;
import org.apache.drill.exec.planner.index.DrillIndexCollection;
import org.apache.drill.exec.planner.index.DrillIndexDefinition;
import org.apache.drill.exec.planner.index.DrillIndexDescriptor;
import org.apache.drill.exec.planner.index.IndexCollection;
import org.apache.drill.exec.planner.index.IndexDefinition;
import org.apache.drill.exec.planner.index.IndexDescriptor;
import org.apache.drill.exec.planner.index.IndexDiscover;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IndexDiscoverBase
implements IndexDiscover {
    static final Logger logger = LoggerFactory.getLogger(IndexDiscoverBase.class);
    private AbstractDbGroupScan scan;
    private RelNode scanRel;

    public IndexDiscoverBase(AbstractDbGroupScan inScan, DrillScanRelBase inScanPrel) {
        this.scan = inScan;
        this.scanRel = inScanPrel;
    }

    public IndexDiscoverBase(AbstractDbGroupScan inScan, ScanPrel inScanPrel) {
        this.scan = inScan;
        this.scanRel = inScanPrel;
    }

    public AbstractDbGroupScan getOriginalScan() {
        return this.scan;
    }

    public RelNode getOriginalScanRel() {
        return this.scanRel;
    }

    public IndexCollection getTableIndex(String tableName, String storageName, Collection<DrillIndexDefinition> indexDefs) {
        HashSet<DrillIndexDescriptor> idxSet = new HashSet<DrillIndexDescriptor>();
        for (DrillIndexDefinition def : indexDefs) {
            DrillIndexDescriptor indexDescriptor = new DrillIndexDescriptor(def);
            this.materializeIndex(storageName, indexDescriptor);
        }
        return new DrillIndexCollection(this.getOriginalScanRel(), idxSet);
    }

    public void materializeIndex(String storageName, DrillIndexDescriptor index) {
        index.setStorageName(storageName);
        index.setDrillTable(this.buildDrillTable(index));
    }

    public DrillTable getExternalDrillTable(IndexDescriptor idxDesc) {
        return null;
    }

    public DrillTable buildDrillTable(IndexDescriptor idxDesc) {
        if (idxDesc.getIndexType() == IndexDefinition.IndexType.EXTERNAL_SECONDARY_INDEX) {
            return this.getExternalDrillTable(idxDesc);
        }
        return this.getNativeDrillTable(idxDesc);
    }

    public abstract DrillTable getNativeDrillTable(IndexDescriptor var1);
}

