/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.planner.index.IndexDescriptor;
import org.apache.drill.exec.planner.index.IndexLogicalPlanCallContext;
import org.apache.drill.exec.planner.index.RexSeparator;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.partition.RewriteCombineBinaryOperators;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;

public class IndexConditionInfo {
    public final RexNode indexCondition;
    public final RexNode remainderCondition;
    public final boolean hasIndexCol;

    public IndexConditionInfo(RexNode indexCondition, RexNode remainderCondition, boolean hasIndexCol) {
        this.indexCondition = indexCondition;
        this.remainderCondition = remainderCondition;
        this.hasIndexCol = hasIndexCol;
    }

    public static Builder newBuilder(RexNode condition, Iterable<IndexDescriptor> indexes, RexBuilder builder, RelNode scan) {
        return new Builder(condition, indexes, builder, scan);
    }

    public static class Builder {
        final RexBuilder builder;
        final RelNode scan;
        final Iterable<IndexDescriptor> indexes;
        private RexNode condition;

        public Builder(RexNode condition, Iterable<IndexDescriptor> indexes, RexBuilder builder, RelNode scan) {
            this.condition = condition;
            this.builder = builder;
            this.scan = scan;
            this.indexes = indexes;
        }

        public Builder(RexNode condition, IndexDescriptor index, RexBuilder builder, DrillScanRel scan) {
            this.condition = condition;
            this.builder = builder;
            this.scan = scan;
            this.indexes = Lists.newArrayList(index);
        }

        public IndexConditionInfo getCollectiveInfo(IndexLogicalPlanCallContext indexContext) {
            LinkedHashSet<LogicalExpression> paths = Sets.newLinkedHashSet();
            for (IndexDescriptor index : this.indexes) {
                paths.addAll(index.getIndexColumns());
            }
            return this.indexConditionRelatedToFields(Lists.newArrayList(paths), this.condition);
        }

        public boolean isValidIndexHint(IndexLogicalPlanCallContext indexContext) {
            if (indexContext.indexHint.equals("")) {
                return false;
            }
            for (IndexDescriptor index : this.indexes) {
                if (!indexContext.indexHint.equals(index.getIndexName())) continue;
                return true;
            }
            return false;
        }

        public Map<IndexDescriptor, IndexConditionInfo> getFirstKeyIndexConditionMap() {
            LinkedHashMap<IndexDescriptor, IndexConditionInfo> indexInfoMap = Maps.newLinkedHashMap();
            RexNode initCondition = this.condition;
            for (IndexDescriptor index : this.indexes) {
                ArrayList<LogicalExpression> leadingColumns = new ArrayList<LogicalExpression>();
                if (initCondition.isAlwaysTrue()) break;
                leadingColumns.add(index.getIndexColumns().get(0));
                IndexConditionInfo info = this.indexConditionRelatedToFields(leadingColumns, initCondition);
                if (info == null || !info.hasIndexCol) {
                    IndexConditionInfo origInfo = this.indexConditionRelatedToFields(leadingColumns, this.condition);
                    if (origInfo == null || !origInfo.hasIndexCol) continue;
                    indexInfoMap.put(index, origInfo);
                    continue;
                }
                indexInfoMap.put(index, info);
                initCondition = info.remainderCondition;
            }
            return indexInfoMap;
        }

        public boolean isConditionPrefix(IndexDescriptor indexDesc, RexNode initCondition) {
            List<LogicalExpression> indexCols = indexDesc.getIndexColumns();
            boolean prefix = true;
            int numPrefix = 0;
            if (indexCols.size() > 0 && initCondition != null) {
                int i = 0;
                while (prefix && i < indexCols.size()) {
                    LogicalExpression p;
                    ImmutableList<LogicalExpression> prefixCol;
                    IndexConditionInfo info;
                    if ((info = this.indexConditionRelatedToFields(prefixCol = ImmutableList.of(p = indexCols.get(i++)), initCondition)) != null && info.hasIndexCol) {
                        ++numPrefix;
                        initCondition = info.remainderCondition;
                        if (!initCondition.isAlwaysTrue()) continue;
                        break;
                    }
                    prefix = false;
                }
            }
            return numPrefix > 0;
        }

        public Map<IndexDescriptor, IndexConditionInfo> getIndexConditionMap(List<IndexDescriptor> indexList) {
            return this.getIndexConditionMapInternal(indexList);
        }

        public Map<IndexDescriptor, IndexConditionInfo> getIndexConditionMap() {
            return this.getIndexConditionMapInternal(Lists.newArrayList(this.indexes));
        }

        private Map<IndexDescriptor, IndexConditionInfo> getIndexConditionMapInternal(List<IndexDescriptor> indexes) {
            LinkedHashMap<IndexDescriptor, IndexConditionInfo> indexInfoMap = Maps.newLinkedHashMap();
            RexNode initCondition = this.condition;
            for (IndexDescriptor index : indexes) {
                IndexConditionInfo info;
                if (initCondition.isAlwaysTrue()) break;
                if (!this.isConditionPrefix(index, initCondition) || (info = this.indexConditionRelatedToFields(index.getIndexColumns(), initCondition)) == null || !info.hasIndexCol) continue;
                initCondition = info.remainderCondition;
                indexInfoMap.put(index, info);
            }
            return indexInfoMap;
        }

        public IndexConditionInfo indexConditionRelatedToFields(List<LogicalExpression> relevantPaths, RexNode condition) {
            RexSeparator separator = new RexSeparator(relevantPaths, this.scan, this.builder);
            RewriteCombineBinaryOperators reverseVisitor = new RewriteCombineBinaryOperators(true, this.builder);
            RexNode indexCondition = separator.getSeparatedCondition(condition = (RexNode)condition.accept((RexVisitor)reverseVisitor));
            if (indexCondition == null) {
                return new IndexConditionInfo(null, null, false);
            }
            List conjuncts = RelOptUtil.conjunctions((RexNode)condition);
            List indexConjuncts = RelOptUtil.conjunctions((RexNode)indexCondition);
            for (RexNode indexConjunction : indexConjuncts) {
                RexUtil.removeAll((List)conjuncts, (RexNode)indexConjunction);
            }
            RexNode remainderCondition = RexUtil.composeConjunction((RexBuilder)this.builder, (Iterable)conjuncts, (boolean)false);
            indexCondition = (RexNode)indexCondition.accept((RexVisitor)reverseVisitor);
            return new IndexConditionInfo(indexCondition, remainderCondition, true);
        }
    }
}

