/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;

public class FindFiltersForCollation
extends RexVisitorImpl<Boolean> {
    private Map<Integer, List<RexNode>> collationFilterMap = Maps.newHashMap();
    private Set<SqlKind> allowedComparisons = Sets.newHashSet();
    private RelDataType inputRowType;
    private int currentFieldIndex;

    public FindFiltersForCollation(RelNode input) {
        super(true);
        this.inputRowType = input.getRowType();
        this.init();
    }

    private void init() {
        this.allowedComparisons.addAll(SqlKind.COMPARISON);
        this.allowedComparisons.add(SqlKind.LIKE);
    }

    public Map<Integer, List<RexNode>> analyze(RexNode indexCondition) {
        int idx = 0;
        while (idx < this.inputRowType.getFieldCount()) {
            this.currentFieldIndex = idx++;
            indexCondition.accept((RexVisitor)this);
        }
        return this.collationFilterMap;
    }

    public Boolean visitInputRef(RexInputRef inputRef) {
        if (inputRef.getIndex() == this.currentFieldIndex) {
            return true;
        }
        return false;
    }

    public Boolean visitLiteral(RexLiteral literal) {
        return true;
    }

    public Boolean visitOver(RexOver over) {
        return false;
    }

    public Boolean visitCorrelVariable(RexCorrelVariable correlVariable) {
        return false;
    }

    public Boolean visitCall(RexCall call) {
        SqlOperator op = call.getOperator();
        SqlKind kind = op.getKind();
        if (kind == SqlKind.AND) {
            for (RexNode n : call.getOperands()) {
                n.accept((RexVisitor)this);
            }
        } else {
            if (kind == SqlKind.CAST) {
                return true;
            }
            if (op == SqlStdOperatorTable.ITEM) {
                List ops = call.getOperands();
                boolean left = (Boolean)((RexNode)ops.get(0)).accept((RexVisitor)this);
                boolean right = (Boolean)((RexNode)ops.get(1)).accept((RexVisitor)this);
                return left && right;
            }
            if (this.allowedComparisons.contains(kind)) {
                List ops = call.getOperands();
                boolean left = (Boolean)((RexNode)ops.get(0)).accept((RexVisitor)this);
                boolean right = (Boolean)((RexNode)ops.get(1)).accept((RexVisitor)this);
                if (left && right) {
                    if (this.collationFilterMap.containsKey(this.currentFieldIndex)) {
                        List<RexNode> n = this.collationFilterMap.get(this.currentFieldIndex);
                        n.add((RexNode)call);
                    } else {
                        ArrayList<RexCall> clist = Lists.newArrayList();
                        clist.add(call);
                        this.collationFilterMap.put(this.currentFieldIndex, clist);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public Boolean visitDynamicParam(RexDynamicParam dynamicParam) {
        return false;
    }

    public Boolean visitRangeRef(RexRangeRef rangeRef) {
        return false;
    }

    public Boolean visitFieldAccess(RexFieldAccess fieldAccess) {
        return false;
    }

    public Boolean visitLocalRef(RexLocalRef localRef) {
        return false;
    }
}

