/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import java.io.IOException;
import java.util.List;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.IndexGroupScan;
import org.apache.drill.exec.planner.cost.PluginCost;
import org.apache.drill.exec.planner.index.AbstractIndexDescriptor;
import org.apache.drill.exec.planner.index.CollationContext;
import org.apache.drill.exec.planner.index.DrillIndexDefinition;
import org.apache.drill.exec.planner.index.FunctionalIndexInfo;
import org.apache.drill.exec.planner.index.IndexDefinition;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillIndexDescriptor
extends AbstractIndexDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(DrillIndexDescriptor.class);
    private String storage;
    private DrillTable table;

    public DrillIndexDescriptor(List<LogicalExpression> indexCols, CollationContext indexCollationContext, List<LogicalExpression> nonIndexCols, List<LogicalExpression> rowKeyColumns, String indexName, String tableName, IndexDefinition.IndexType type, RelFieldCollation.NullDirection nullsDirection) {
        super(indexCols, indexCollationContext, nonIndexCols, rowKeyColumns, indexName, tableName, type, nullsDirection);
    }

    public DrillIndexDescriptor(DrillIndexDefinition def) {
        this(def.indexColumns, def.indexCollationContext, def.nonIndexColumns, def.rowKeyColumns, def.indexName, def.getTableName(), def.getIndexType(), def.nullsDirection);
    }

    @Override
    public double getRows(RelNode scan, RexNode indexCondition) {
        return 1.0;
    }

    @Override
    public IndexGroupScan getIndexGroupScan() {
        try {
            DrillTable idxTable = this.getDrillTable();
            GroupScan scan = idxTable.getGroupScan();
            if (!(scan instanceof IndexGroupScan)) {
                logger.error("The Groupscan from table {} is not an IndexGroupScan", (Object)idxTable.toString());
                return null;
            }
            return (IndexGroupScan)scan;
        }
        catch (IOException e) {
            logger.error("Error in getIndexGroupScan ", (Throwable)e);
            return null;
        }
    }

    public void setStorageName(String storageName) {
        this.storage = storageName;
    }

    public String getStorageName() {
        return this.storage;
    }

    public void setDrillTable(DrillTable table) {
        this.table = table;
    }

    public DrillTable getDrillTable() {
        return this.table;
    }

    @Override
    public FunctionalIndexInfo getFunctionalInfo() {
        return null;
    }

    @Override
    public PluginCost getPluginCostModel() {
        return null;
    }
}

