/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.exec.physical.base.IndexGroupScan;
import org.apache.drill.exec.planner.index.AbstractIndexCollection;
import org.apache.drill.exec.planner.index.DrillIndexDescriptor;
import org.apache.drill.exec.planner.index.IndexCollection;
import org.apache.drill.exec.planner.index.IndexDescriptor;

public class DrillIndexCollection
extends AbstractIndexCollection {
    private final RelNode scan;

    public DrillIndexCollection(RelNode scanRel, Set<DrillIndexDescriptor> indexes) {
        this.scan = scanRel;
        for (IndexDescriptor indexDescriptor : indexes) {
            super.addIndex(indexDescriptor);
        }
    }

    private IndexDescriptor getIndexDescriptor() {
        return (IndexDescriptor)this.indexes.iterator().next();
    }

    @Override
    public boolean supportsIndexSelection() {
        return true;
    }

    @Override
    public boolean supportsRowCountStats() {
        return true;
    }

    @Override
    public boolean supportsFullTextSearch() {
        return true;
    }

    @Override
    public double getRows(RexNode indexCondition) {
        return this.getIndexDescriptor().getRows(this.scan, indexCondition);
    }

    @Override
    public IndexGroupScan getGroupScan() {
        return this.getIndexDescriptor().getIndexGroupScan();
    }

    @Override
    public IndexCollection.IndexCollectionType getIndexCollectionType() {
        return IndexCollection.IndexCollectionType.EXTERNAL_SECONDARY_INDEX_COLLECTION;
    }
}

