/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment.contrib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.base.Exchange;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.planner.fragment.DefaultQueryParallelizer;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.planner.fragment.Materializer;
import org.apache.drill.exec.planner.fragment.PlanningSet;
import org.apache.drill.exec.planner.fragment.SimpleParallelizer;
import org.apache.drill.exec.planner.fragment.Wrapper;
import org.apache.drill.exec.planner.fragment.contrib.ExchangeRemoverMaterializer;
import org.apache.drill.exec.planner.fragment.contrib.OperatorIdVisitor;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.options.OptionList;
import org.apache.drill.exec.work.QueryWorkUnit;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplittingParallelizer
extends DefaultQueryParallelizer {
    private boolean enableDynamicFC;
    private static final Logger logger = LoggerFactory.getLogger(SplittingParallelizer.class);

    public SplittingParallelizer(boolean doMemoryPlanning, QueryContext context) {
        super(doMemoryPlanning, context);
        this.enableDynamicFC = context.getOptions().getBoolean("exec.enable_dynamic_fc");
    }

    @Override
    public List<QueryWorkUnit> getSplitFragments(OptionList options, CoordinationProtos.DrillbitEndpoint foremanNode, UserBitShared.QueryId queryId, Collection<CoordinationProtos.DrillbitEndpoint> activeEndpoints, PhysicalPlanReader reader, Fragment rootFragment, UserSession session, BitControl.QueryContextInformation queryContextInfo) throws ExecutionSetupException {
        PlanningSet planningSet = this.prepareFragmentTree(rootFragment);
        Set<Wrapper> rootFragments = this.getRootFragments(planningSet);
        this.collectStatsAndParallelizeFragments(planningSet, rootFragments, activeEndpoints);
        this.adjustMemory(planningSet, rootFragments, activeEndpoints);
        return this.generateWorkUnits(options, foremanNode, queryId, reader, rootFragment, planningSet, session, queryContextInfo);
    }

    private List<QueryWorkUnit> generateWorkUnits(OptionList options, CoordinationProtos.DrillbitEndpoint foremanNode, UserBitShared.QueryId queryId, PhysicalPlanReader reader, Fragment rootNode, PlanningSet planningSet, UserSession session, BitControl.QueryContextInformation queryContextInfo) throws ExecutionSetupException {
        ArrayList<QueryWorkUnit> workUnits = Lists.newArrayList();
        int plansCount = 0;
        CoordinationProtos.DrillbitEndpoint[] leafFragEndpoints = null;
        long initialAllocation = 0L;
        for (Wrapper wrapper : planningSet) {
            boolean isLeafFragment;
            Fragment node = wrapper.getNode();
            boolean bl = isLeafFragment = node.getReceivingExchangePairs().size() == 0;
            PhysicalOperator physicalOperatorRoot = node.getRoot();
            if (!(physicalOperatorRoot instanceof Exchange) || !isLeafFragment) continue;
            plansCount = wrapper.getWidth();
            initialAllocation = wrapper.getInitialAllocation() != 0L ? wrapper.getInitialAllocation() / (long)plansCount : 0L;
            leafFragEndpoints = new CoordinationProtos.DrillbitEndpoint[plansCount];
            for (int mfId = 0; mfId < plansCount; ++mfId) {
                leafFragEndpoints[mfId] = wrapper.getAssignedEndpoint(mfId);
            }
        }
        CoordinationProtos.DrillbitEndpoint[] endPoints = leafFragEndpoints;
        if (plansCount == 0) {
            workUnits.add(this.generateWorkUnit(options, foremanNode, queryId, rootNode, planningSet, session, queryContextInfo));
            return workUnits;
        }
        for (Wrapper wrapper : planningSet) {
            boolean isRootNode;
            Fragment node = wrapper.getNode();
            PhysicalOperator physicalOperatorRoot = node.getRoot();
            if (physicalOperatorRoot instanceof Exchange) continue;
            boolean bl = isRootNode = rootNode == node;
            if (isRootNode && wrapper.getWidth() != 1) {
                throw new ForemanSetupException(String.format("Failure while trying to setup fragment. The root fragment must always have parallelization one. In the current case, the width was set to %d.", wrapper.getWidth()));
            }
            boolean isLeafFragment = true;
            ExecProtos.FragmentHandle handle = ExecProtos.FragmentHandle.newBuilder().setMajorFragmentId(wrapper.getMajorFragmentId()).setMinorFragmentId(0).setQueryId(queryId).build();
            for (int minorFragmentId = 0; minorFragmentId < plansCount; ++minorFragmentId) {
                ArrayList<QueryWorkUnit.MinorFragmentDefn> fragments = Lists.newArrayList();
                QueryWorkUnit.MinorFragmentDefn rootFragment = null;
                FragmentRoot rootOperator = null;
                Materializer.IndexedFragmentNode iNode = new Materializer.IndexedFragmentNode(minorFragmentId, wrapper, (fragmentWrapper, minorFragment) -> endPoints[minorFragment], this.getMemory());
                wrapper.resetAllocation();
                PhysicalOperator op = physicalOperatorRoot.accept(ExchangeRemoverMaterializer.INSTANCE, iNode).accept(OperatorIdVisitor.INSTANCE, 0);
                Preconditions.checkArgument(op instanceof FragmentRoot);
                FragmentRoot root = (FragmentRoot)op;
                BitControl.PlanFragment fragment = BitControl.PlanFragment.newBuilder().setForeman(endPoints[minorFragmentId]).setHandle(handle).setAssignment(endPoints[minorFragmentId]).setLeafFragment(isLeafFragment).setContext(queryContextInfo).setMemInitial(initialAllocation).setMemMax(wrapper.getMaxAllocation()).setCredentials(session.getCredentials()).addAllCollector(SimpleParallelizer.CountRequiredFragments.getCollectors(root, this.enableDynamicFC)).build();
                QueryWorkUnit.MinorFragmentDefn fragmentDefn = new QueryWorkUnit.MinorFragmentDefn(fragment, root, options);
                if (isRootNode) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Root fragment:\n {}", (Object)DrillStringUtils.unescapeJava(fragment.toString()));
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Remote fragment:\n {}", (Object)DrillStringUtils.unescapeJava(fragment.toString()));
                    }
                    throw new ForemanSetupException(String.format("There should not be non-root/remote fragment present in plan split, but there is: %s", DrillStringUtils.unescapeJava(fragment.toString())));
                }
                rootFragment = fragmentDefn;
                rootOperator = root;
                workUnits.add(new QueryWorkUnit(rootOperator, rootFragment, fragments, planningSet.getRootWrapper()));
            }
        }
        return workUnits;
    }
}

