/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment.contrib;

import java.util.ArrayList;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.exception.FragmentSetupException;
import org.apache.drill.exec.physical.PhysicalOperatorSetupException;
import org.apache.drill.exec.physical.base.AbstractPhysicalVisitor;
import org.apache.drill.exec.physical.base.Exchange;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Store;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.planner.fragment.Materializer;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class ExchangeRemoverMaterializer
extends AbstractPhysicalVisitor<PhysicalOperator, Materializer.IndexedFragmentNode, ExecutionSetupException> {
    public static final ExchangeRemoverMaterializer INSTANCE = new ExchangeRemoverMaterializer();

    private ExchangeRemoverMaterializer() {
    }

    @Override
    public PhysicalOperator visitExchange(Exchange exchange, Materializer.IndexedFragmentNode iNode) throws ExecutionSetupException {
        iNode.addAllocation(exchange);
        PhysicalOperator childEx = exchange.getChild().accept(this, iNode);
        return childEx;
    }

    @Override
    public PhysicalOperator visitGroupScan(GroupScan groupScan, Materializer.IndexedFragmentNode iNode) throws ExecutionSetupException {
        SubScan child = groupScan.getSpecificScan(iNode.getMinorFragmentId());
        return child;
    }

    @Override
    public PhysicalOperator visitSubScan(SubScan subScan, Materializer.IndexedFragmentNode value) throws ExecutionSetupException {
        value.addAllocation(subScan);
        return (PhysicalOperator)super.visitOp((PhysicalOperator)subScan, value);
    }

    @Override
    public PhysicalOperator visitStore(Store store, Materializer.IndexedFragmentNode iNode) throws ExecutionSetupException {
        PhysicalOperator child = store.getChild().accept(this, iNode);
        iNode.addAllocation(store);
        try {
            Store o = store.getSpecificStore(child, iNode.getMinorFragmentId());
            return o;
        }
        catch (PhysicalOperatorSetupException e) {
            throw new FragmentSetupException("Failure while generating a specific Store materialization.", e);
        }
    }

    @Override
    public PhysicalOperator visitOp(PhysicalOperator op, Materializer.IndexedFragmentNode iNode) throws ExecutionSetupException {
        iNode.addAllocation(op);
        ArrayList<PhysicalOperator> children = Lists.newArrayList();
        for (PhysicalOperator child : op) {
            children.add(child.accept(this, iNode));
        }
        PhysicalOperator newOp = op.getNewWithChildren(children);
        newOp.setCost(op.getCost());
        return newOp;
    }
}

