/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.function.BiFunction;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.exception.FragmentSetupException;
import org.apache.drill.exec.physical.PhysicalOperatorSetupException;
import org.apache.drill.exec.physical.base.AbstractPhysicalVisitor;
import org.apache.drill.exec.physical.base.Exchange;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.exec.physical.base.Store;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.physical.config.LateralJoinPOP;
import org.apache.drill.exec.physical.config.RowKeyJoinPOP;
import org.apache.drill.exec.physical.config.UnnestPOP;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.planner.fragment.Wrapper;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class Materializer
extends AbstractPhysicalVisitor<PhysicalOperator, IndexedFragmentNode, ExecutionSetupException> {
    public static final Materializer INSTANCE = new Materializer();

    private Materializer() {
    }

    @Override
    public PhysicalOperator visitExchange(Exchange exchange, IndexedFragmentNode iNode) throws ExecutionSetupException {
        iNode.addAllocation(exchange);
        if (exchange == iNode.getNode().getSendingExchange()) {
            PhysicalOperator child = exchange.getChild().accept(this, iNode);
            Sender materializedSender = exchange.getSender(iNode.getMinorFragmentId(), child);
            materializedSender.setOperatorId(0);
            materializedSender.setCost(exchange.getCost());
            return materializedSender;
        }
        Receiver materializedReceiver = exchange.getReceiver(iNode.getMinorFragmentId());
        materializedReceiver.setOperatorId(Short.MAX_VALUE & exchange.getOperatorId());
        materializedReceiver.setCost(exchange.getCost());
        return materializedReceiver;
    }

    @Override
    public PhysicalOperator visitGroupScan(GroupScan groupScan, IndexedFragmentNode iNode) throws ExecutionSetupException {
        SubScan child = groupScan.getSpecificScan(iNode.getMinorFragmentId());
        child.setOperatorId(Short.MAX_VALUE & groupScan.getOperatorId());
        iNode.addSubScan(child);
        return child;
    }

    @Override
    public PhysicalOperator visitSubScan(SubScan subScan, IndexedFragmentNode value) throws ExecutionSetupException {
        value.addAllocation(subScan);
        value.addSubScan(subScan);
        return (PhysicalOperator)super.visitOp((PhysicalOperator)subScan, value);
    }

    @Override
    public PhysicalOperator visitStore(Store store, IndexedFragmentNode iNode) throws ExecutionSetupException {
        PhysicalOperator child = store.getChild().accept(this, iNode);
        iNode.addAllocation(store);
        try {
            Store o = store.getSpecificStore(child, iNode.getMinorFragmentId());
            o.setOperatorId(Short.MAX_VALUE & store.getOperatorId());
            return o;
        }
        catch (PhysicalOperatorSetupException e) {
            throw new FragmentSetupException("Failure while generating a specific Store materialization.");
        }
    }

    @Override
    public PhysicalOperator visitOp(PhysicalOperator op, IndexedFragmentNode iNode) throws ExecutionSetupException {
        iNode.addAllocation(op);
        ArrayList<PhysicalOperator> children = Lists.newArrayList();
        for (PhysicalOperator child : op) {
            children.add(child.accept(this, iNode));
        }
        PhysicalOperator newOp = op.getNewWithChildren(children);
        newOp.setCost(op.getCost());
        newOp.setOperatorId(Short.MAX_VALUE & op.getOperatorId());
        return newOp;
    }

    @Override
    public PhysicalOperator visitLateralJoin(LateralJoinPOP op, IndexedFragmentNode iNode) throws ExecutionSetupException {
        iNode.addAllocation(op);
        ArrayList<PhysicalOperator> children = Lists.newArrayList();
        children.add(op.getLeft().accept(this, iNode));
        children.add(op.getRight().accept(this, iNode));
        UnnestPOP unnestForThisLateral = iNode.getUnnest();
        PhysicalOperator newOp = op.getNewWithChildren(children);
        newOp.setCost(op.getCost());
        newOp.setOperatorId(Short.MAX_VALUE & op.getOperatorId());
        ((LateralJoinPOP)newOp).setUnnestForLateralJoin(unnestForThisLateral);
        return newOp;
    }

    @Override
    public PhysicalOperator visitUnnest(UnnestPOP unnest, IndexedFragmentNode value) throws ExecutionSetupException {
        PhysicalOperator newOp = this.visitOp((PhysicalOperator)unnest, value);
        value.addUnnest((UnnestPOP)newOp);
        return newOp;
    }

    @Override
    public PhysicalOperator visitRowKeyJoin(RowKeyJoinPOP op, IndexedFragmentNode iNode) throws ExecutionSetupException {
        iNode.addAllocation(op);
        ArrayList<PhysicalOperator> children = Lists.newArrayList();
        children.add(op.getLeft().accept(this, iNode));
        SubScan subScanInLeftInput = iNode.getSubScan();
        children.add(op.getRight().accept(this, iNode));
        PhysicalOperator newOp = op.getNewWithChildren(children);
        newOp.setCost(op.getCost());
        newOp.setOperatorId(Short.MAX_VALUE & op.getOperatorId());
        ((RowKeyJoinPOP)newOp).setSubScanForRowKeyJoin(subScanInLeftInput);
        return newOp;
    }

    public static class IndexedFragmentNode {
        private final Wrapper info;
        private final BiFunction<Wrapper, Integer, CoordinationProtos.DrillbitEndpoint> endpoint;
        private final int minorFragmentId;
        private final BiFunction<CoordinationProtos.DrillbitEndpoint, PhysicalOperator, Long> memoryPerOperPerDrillbit;
        SubScan subScan;
        private final Deque<UnnestPOP> unnest = new ArrayDeque<UnnestPOP>();

        public IndexedFragmentNode(int minorFragmentId, Wrapper info, BiFunction<Wrapper, Integer, CoordinationProtos.DrillbitEndpoint> wrapperToEndpoint, BiFunction<CoordinationProtos.DrillbitEndpoint, PhysicalOperator, Long> memoryReqs) {
            this.info = info;
            this.endpoint = wrapperToEndpoint;
            this.minorFragmentId = minorFragmentId;
            this.memoryPerOperPerDrillbit = memoryReqs;
        }

        public Fragment getNode() {
            return this.info.getNode();
        }

        public int getMinorFragmentId() {
            return this.minorFragmentId;
        }

        public Wrapper getInfo() {
            return this.info;
        }

        public void addAllocation(PhysicalOperator pop) {
            this.info.addInitialAllocation(pop.getInitialAllocation());
            long maxAllocation = this.memoryPerOperPerDrillbit.apply(this.endpoint.apply(this.info, this.minorFragmentId), pop);
            this.info.addMaxAllocation(maxAllocation);
            pop.setMaxAllocation(maxAllocation);
        }

        public void addUnnest(UnnestPOP unnest) {
            this.unnest.addFirst(unnest);
        }

        public UnnestPOP getUnnest() {
            return this.unnest.removeFirst();
        }

        public void addSubScan(SubScan subScan) {
            this.subScan = subScan;
        }

        public SubScan getSubScan() {
            return this.subScan;
        }
    }
}

