/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment;

import org.apache.drill.exec.physical.base.AbstractPhysicalVisitor;
import org.apache.drill.exec.physical.base.Exchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.work.foreman.ForemanSetupException;

public class MakeFragmentsVisitor
extends AbstractPhysicalVisitor<Fragment, Fragment, ForemanSetupException> {
    public static final MakeFragmentsVisitor INSTANCE = new MakeFragmentsVisitor();

    private MakeFragmentsVisitor() {
    }

    @Override
    public Fragment visitExchange(Exchange exchange, Fragment receivingFragment) throws ForemanSetupException {
        if (receivingFragment == null) {
            throw new ForemanSetupException("The simple fragmenter was called without a FragmentBuilder value. This will only happen if the initial call to SimpleFragmenter is by a Exchange node.  This should never happen since an Exchange node should never be the root node of a plan.");
        }
        Fragment sendingFragment = this.getNextFragment();
        receivingFragment.addReceiveExchange(exchange, sendingFragment);
        sendingFragment.addSendExchange(exchange, receivingFragment);
        exchange.getChild().accept(this, sendingFragment);
        return sendingFragment;
    }

    @Override
    public Fragment visitOp(PhysicalOperator op, Fragment value) throws ForemanSetupException {
        value = this.ensureBuilder(value);
        value.addOperator(op);
        for (PhysicalOperator child : op) {
            child.accept(this, value);
        }
        return value;
    }

    private Fragment ensureBuilder(Fragment currentFragment) throws ForemanSetupException {
        if (currentFragment != null) {
            return currentFragment;
        }
        return this.getNextFragment();
    }

    public Fragment getNextFragment() {
        return new Fragment();
    }
}

