/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.fragment.PlanningSet;
import org.apache.drill.exec.planner.fragment.SimpleParallelizer;
import org.apache.drill.exec.planner.fragment.Wrapper;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.util.MemoryAllocationUtilities;

public class DefaultQueryParallelizer
extends SimpleParallelizer {
    private final boolean planHasMemory;
    private final QueryContext queryContext;

    public DefaultQueryParallelizer(boolean memoryAvailableInPlan, QueryContext queryContext) {
        super(queryContext);
        this.planHasMemory = memoryAvailableInPlan;
        this.queryContext = queryContext;
    }

    public DefaultQueryParallelizer(boolean memoryPlanning, long parallelizationThreshold, int maxWidthPerNode, int maxGlobalWidth, double affinityFactor) {
        super(parallelizationThreshold, maxWidthPerNode, maxGlobalWidth, affinityFactor);
        this.planHasMemory = memoryPlanning;
        this.queryContext = null;
    }

    @Override
    public void adjustMemory(PlanningSet planningSet, Set<Wrapper> roots, Collection<CoordinationProtos.DrillbitEndpoint> activeEndpoints) {
        if (this.planHasMemory) {
            return;
        }
        List<PhysicalOperator> bufferedOpers = planningSet.getRootWrapper().getNode().getBufferedOperators(this.queryContext);
        MemoryAllocationUtilities.setupBufferedOpsMemoryAllocations(this.planHasMemory, bufferedOpers, this.queryContext);
    }

    @Override
    protected BiFunction<CoordinationProtos.DrillbitEndpoint, PhysicalOperator, Long> getMemory() {
        return (endpoint, operator) -> operator.getMaxAllocation();
    }
}

