/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.cost;

import java.util.Map;
import org.apache.drill.exec.proto.CoordinationProtos;

public class NodeResource {
    private long cpu;
    private long memory;

    public NodeResource(long cpu, long memory) {
        this.cpu = cpu;
        this.memory = memory;
    }

    public void add(NodeResource other) {
        if (other == null) {
            return;
        }
        this.cpu += other.cpu;
        this.memory += other.memory;
    }

    public long getMemory() {
        return this.memory;
    }

    public static Map<CoordinationProtos.DrillbitEndpoint, NodeResource> merge(Map<CoordinationProtos.DrillbitEndpoint, NodeResource> to, Map<CoordinationProtos.DrillbitEndpoint, NodeResource> from) {
        to.entrySet().stream().forEach(toEntry -> ((NodeResource)toEntry.getValue()).add((NodeResource)from.get(toEntry.getKey())));
        return to;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CPU: ").append(this.cpu).append("Memory: ").append(this.memory);
        return sb.toString();
    }

    public static NodeResource create() {
        return NodeResource.create(0L, 0L);
    }

    public static NodeResource create(long cpu) {
        return NodeResource.create(cpu, 0L);
    }

    public static NodeResource create(long cpu, long memory) {
        return new NodeResource(cpu, memory);
    }
}

