/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.cost;

import java.util.Objects;
import org.apache.calcite.plan.RelOptCost;
import org.apache.drill.exec.planner.cost.DrillRelOptCost;
import org.apache.drill.exec.planner.cost.DrillRelOptCostFactory;

public class DrillCostBase
implements DrillRelOptCost {
    public static final int BASE_CPU_COST = 1;
    public static final int BYTE_DISK_READ_COST = 32;
    public static final int BYTE_NETWORK_COST = 512;
    public static final int SVR_CPU_COST = 8;
    public static final int FUNC_CPU_COST = 12;
    public static final int PROJECT_CPU_COST = 4;
    public static final int HASH_CPU_COST = 8;
    public static final double MEMORY_TO_CPU_RATIO = 1.0;
    public static final int RANGE_PARTITION_CPU_COST = 12;
    public static final int COMPARE_CPU_COST = 4;
    public static final int AVG_FIELD_WIDTH = 8;
    static final DrillCostBase INFINITY = new DrillCostBase(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY){

        @Override
        public String toString() {
            return "{inf}";
        }
    };
    static final DrillCostBase HUGE = new DrillCostBase(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE){

        @Override
        public String toString() {
            return "{huge}";
        }
    };
    static final DrillCostBase ZERO = new DrillCostBase(0.0, 0.0, 0.0, 0.0){

        @Override
        public String toString() {
            return "{0}";
        }
    };
    static final DrillCostBase TINY = new DrillCostBase(1.0, 1.0, 0.0, 0.0){

        @Override
        public String toString() {
            return "{tiny}";
        }
    };
    final double rowCount;
    final double cpu;
    final double io;
    final double network;
    final double memory;

    public DrillCostBase(double rowCount, double cpu, double io, double network) {
        this(rowCount, cpu, io, network, 0.0);
    }

    public DrillCostBase(double rowCount, double cpu, double io, double network, double memory) {
        this.rowCount = rowCount;
        this.cpu = cpu;
        this.io = io;
        this.network = network;
        this.memory = memory;
    }

    public double getRows() {
        return this.rowCount;
    }

    public double getCpu() {
        return this.cpu;
    }

    public double getIo() {
        return this.io;
    }

    @Override
    public double getNetwork() {
        return this.network;
    }

    @Override
    public double getMemory() {
        return this.memory;
    }

    public int hashCode() {
        return Objects.hash(this.rowCount, this.cpu, this.io, this.network);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        DrillCostBase thatConfig = (DrillCostBase)that;
        return Objects.equals(this.rowCount, thatConfig.rowCount) && Objects.equals(this.cpu, thatConfig.cpu) && Objects.equals(this.io, thatConfig.io) && Objects.equals(this.network, thatConfig.network);
    }

    public boolean isInfinite() {
        return this == INFINITY || this.cpu == Double.POSITIVE_INFINITY || this.io == Double.POSITIVE_INFINITY || this.network == Double.POSITIVE_INFINITY || this.rowCount == Double.POSITIVE_INFINITY || this.memory == Double.POSITIVE_INFINITY;
    }

    public boolean equals(RelOptCost other) {
        return this == other || other instanceof DrillCostBase && this.cpu == ((DrillCostBase)other).cpu && this.io == ((DrillCostBase)other).io && this.network == ((DrillCostBase)other).network && this.rowCount == ((DrillCostBase)other).rowCount && this.memory == ((DrillCostBase)other).memory;
    }

    public boolean isEqWithEpsilon(RelOptCost other) {
        if (!(other instanceof DrillCostBase)) {
            return false;
        }
        DrillCostBase that = (DrillCostBase)other;
        return this == that || Math.abs(this.cpu - that.cpu) < 1.0E-5 && Math.abs(this.io - that.io) < 1.0E-5 && Math.abs(this.network - that.network) < 1.0E-5 && Math.abs(this.rowCount - that.rowCount) < 1.0E-5 && Math.abs(this.memory - that.memory) < 1.0E-5;
    }

    public boolean isLe(RelOptCost other) {
        DrillCostBase that = (DrillCostBase)other;
        return this == that || this.cpu + this.io + this.network + this.memory * 1.0 <= that.cpu + that.io + that.network + that.memory * 1.0;
    }

    public boolean isLt(RelOptCost other) {
        DrillCostBase that = (DrillCostBase)other;
        return this.cpu + this.io + this.network + this.memory * 1.0 < that.cpu + that.io + that.network + that.memory * 1.0;
    }

    public RelOptCost plus(RelOptCost other) {
        DrillCostBase that = (DrillCostBase)other;
        if (this == INFINITY || that == INFINITY) {
            return INFINITY;
        }
        return new DrillCostBase(this.rowCount + that.rowCount, this.cpu + that.cpu, this.io + that.io, this.network + that.network, this.memory + that.memory);
    }

    public RelOptCost minus(RelOptCost other) {
        if (this == INFINITY) {
            return this;
        }
        DrillCostBase that = (DrillCostBase)other;
        return new DrillCostBase(this.rowCount - that.rowCount, this.cpu - that.cpu, this.io - that.io, this.network - that.network, this.memory - that.memory);
    }

    public RelOptCost multiplyBy(double factor) {
        if (this == INFINITY) {
            return this;
        }
        return new DrillCostBase(this.rowCount * factor, this.cpu * factor, this.io * factor, this.network * factor, this.memory * factor);
    }

    public double divideBy(RelOptCost cost) {
        DrillCostBase that = (DrillCostBase)cost;
        double d = 1.0;
        double n = 0.0;
        if (this.rowCount != 0.0 && !Double.isInfinite(this.rowCount) && that.rowCount != 0.0 && !Double.isInfinite(that.rowCount)) {
            d *= this.rowCount / that.rowCount;
            n += 1.0;
        }
        if (this.cpu != 0.0 && !Double.isInfinite(this.cpu) && that.cpu != 0.0 && !Double.isInfinite(that.cpu)) {
            d *= this.cpu / that.cpu;
            n += 1.0;
        }
        if (this.io != 0.0 && !Double.isInfinite(this.io) && that.io != 0.0 && !Double.isInfinite(that.io)) {
            d *= this.io / that.io;
            n += 1.0;
        }
        if (this.network != 0.0 && !Double.isInfinite(this.network) && that.network != 0.0 && !Double.isInfinite(that.network)) {
            d *= this.network / that.network;
            n += 1.0;
        }
        if (n == 0.0) {
            return 1.0;
        }
        return Math.pow(d, 1.0 / n);
    }

    public String toString() {
        return "{" + this.rowCount + " rows, " + this.cpu + " cpu, " + this.io + " io, " + this.network + " network, " + this.memory + " memory}";
    }

    public static class DrillCostFactory
    implements DrillRelOptCostFactory {
        public RelOptCost makeCost(double dRows, double dCpu, double dIo, double dNetwork, double dMemory) {
            return new DrillCostBase(dRows, dCpu, dIo, dNetwork, dMemory);
        }

        @Override
        public RelOptCost makeCost(double dRows, double dCpu, double dIo, double dNetwork) {
            return new DrillCostBase(dRows, dCpu, dIo, dNetwork, 0.0);
        }

        public RelOptCost makeCost(double dRows, double dCpu, double dIo) {
            return new DrillCostBase(dRows, dCpu, dIo, 0.0, 0.0);
        }

        public RelOptCost makeHugeCost() {
            return HUGE;
        }

        public RelOptCost makeInfiniteCost() {
            return INFINITY;
        }

        public RelOptCost makeTinyCost() {
            return TINY;
        }

        public RelOptCost makeZeroCost() {
            return ZERO;
        }
    }
}

