/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.exec.planner.common.DrillRelNode;
import org.apache.drill.exec.planner.cost.DrillCostBase;

public class DrillUnnestRelBase
extends AbstractRelNode
implements DrillRelNode {
    protected final RexNode ref;
    public static final String IMPLICIT_COLUMN = "$drill_implicit_field$";

    public DrillUnnestRelBase(RelOptCluster cluster, RelTraitSet traitSet, RexNode ref) {
        super(cluster, traitSet);
        this.ref = ref;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount((RelNode)this);
        double cpuCost = 1.0 * rowCount * (double)this.getRowType().getFieldCount();
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(rowCount, cpuCost, 0.0, 0.0);
    }

    public RexNode getRef() {
        return this.ref;
    }
}

