/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.exec.planner.StarColumnHelper;
import org.apache.drill.exec.planner.common.DrillRelNode;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public abstract class DrillProjectRelBase
extends Project
implements DrillRelNode {
    private final int nonSimpleFieldCount;

    protected DrillProjectRelBase(Convention convention, RelOptCluster cluster, RelTraitSet traits, RelNode child, List<? extends RexNode> exps, RelDataType rowType) {
        super(cluster, traits, child, exps, rowType);
        assert (this.getConvention() == convention);
        this.nonSimpleFieldCount = this.getRowType().getFieldCount() - this.getSimpleFieldCount();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        double rowCount = mq.getRowCount((RelNode)this);
        double cpuCost = 4.0 * rowCount * (double)this.nonSimpleFieldCount + (double)(this.getRowType().getFieldCount() - this.nonSimpleFieldCount) * rowCount * 1.0;
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(rowCount, cpuCost, 0.0, 0.0);
    }

    private List<Pair<RexNode, String>> projects() {
        return Pair.zip((List)this.exps, (List)this.getRowType().getFieldNames());
    }

    protected List<NamedExpression> getProjectExpressions(DrillParseContext context) {
        ArrayList<NamedExpression> expressions = Lists.newArrayList();
        HashMap<String, String> starColPrefixes = new HashMap<String, String>();
        for (Pair<RexNode, String> pair : this.projects()) {
            String prefix;
            if (!StarColumnHelper.isPrefixedStarColumn((String)pair.right) || starColPrefixes.containsKey(prefix = StarColumnHelper.extractStarColumnPrefix((String)pair.right))) continue;
            starColPrefixes.put(prefix, (String)pair.right);
        }
        for (Pair<RexNode, String> pair : this.projects()) {
            if (StarColumnHelper.subsumeColumn(starColPrefixes, (String)pair.right)) continue;
            LogicalExpression expr = DrillOptiq.toDrill(context, this.getInput(), (RexNode)pair.left);
            expressions.add(new NamedExpression(expr, FieldReference.getWithQuotedRef((CharSequence)pair.right)));
        }
        return expressions;
    }

    private int getSimpleFieldCount() {
        int cnt = 0;
        ComplexFieldWithNamedSegmentIdentifier complexFieldIdentifer = new ComplexFieldWithNamedSegmentIdentifier();
        for (RexNode expr : this.getProjects()) {
            if (expr instanceof RexInputRef) {
                ++cnt;
                continue;
            }
            if (!(expr instanceof RexCall) || !((Boolean)expr.accept((RexVisitor)complexFieldIdentifer)).booleanValue()) continue;
            ++cnt;
        }
        return cnt;
    }

    private static class ComplexFieldWithNamedSegmentIdentifier
    extends RexVisitorImpl<Boolean> {
        protected ComplexFieldWithNamedSegmentIdentifier() {
            super(true);
        }

        public Boolean visitInputRef(RexInputRef inputRef) {
            return true;
        }

        public Boolean visitLocalRef(RexLocalRef localRef) {
            return this.doUnknown(localRef);
        }

        public Boolean visitLiteral(RexLiteral literal) {
            return this.doUnknown(literal);
        }

        public Boolean visitOver(RexOver over) {
            return this.doUnknown(over);
        }

        public Boolean visitCorrelVariable(RexCorrelVariable correlVariable) {
            return this.doUnknown(correlVariable);
        }

        public Boolean visitCall(RexCall call) {
            if (call.getOperator() == SqlStdOperatorTable.ITEM) {
                RexNode op0 = (RexNode)call.getOperands().get(0);
                RexNode op1 = (RexNode)call.getOperands().get(1);
                if (op0 instanceof RexInputRef && op1 instanceof RexLiteral && ((RexLiteral)op1).getTypeName() == SqlTypeName.CHAR) {
                    return true;
                }
                if (op0 instanceof RexCall && op1 instanceof RexLiteral && ((RexLiteral)op1).getTypeName() == SqlTypeName.CHAR) {
                    return (Boolean)op0.accept((RexVisitor)this);
                }
            }
            return false;
        }

        public Boolean visitDynamicParam(RexDynamicParam dynamicParam) {
            return this.doUnknown(dynamicParam);
        }

        public Boolean visitRangeRef(RexRangeRef rangeRef) {
            return this.doUnknown(rangeRef);
        }

        public Boolean visitFieldAccess(RexFieldAccess fieldAccess) {
            return this.doUnknown(fieldAccess);
        }

        private boolean doUnknown(Object o) {
            return false;
        }
    }
}

