/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.exec.planner.common.DrillRelNode;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.PrelUtil;

public abstract class DrillLimitRelBase
extends SingleRel
implements DrillRelNode {
    protected RexNode offset;
    protected RexNode fetch;
    private final boolean pushDown;

    public DrillLimitRelBase(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode offset, RexNode fetch) {
        this(cluster, traitSet, child, offset, fetch, false);
    }

    public DrillLimitRelBase(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode offset, RexNode fetch, boolean pushDown) {
        super(cluster, traitSet, child);
        this.offset = offset;
        this.fetch = fetch;
        this.pushDown = pushDown;
    }

    public abstract RelNode copy(RelTraitSet var1, List<RelNode> var2, boolean var3);

    public RexNode getOffset() {
        return this.offset;
    }

    public RexNode getFetch() {
        return this.fetch;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        double numRows = this.estimateRowCount(mq);
        double cpuCost = 4.0 * numRows;
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(numRows, cpuCost, 0.0, 0.0);
    }

    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        pw.itemIf("offset", (Object)this.offset, this.offset != null);
        pw.itemIf("fetch", (Object)this.fetch, this.fetch != null);
        return pw;
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        int off;
        int n = off = this.offset != null ? RexLiteral.intValue((RexNode)this.offset) : 0;
        if (this.fetch == null) {
            return Math.max(0.0, this.getInput().estimateRowCount(mq) - (double)off);
        }
        int f = RexLiteral.intValue((RexNode)this.fetch);
        return off + f;
    }

    public boolean isPushDown() {
        return this.pushDown;
    }
}

