/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.drill.exec.physical.impl.join.JoinUtils;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.logical.DrillJoin;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public abstract class DrillJoinRelBase
extends Join
implements DrillJoin {
    protected List<Integer> leftKeys = Lists.newArrayList();
    protected List<Integer> rightKeys = Lists.newArrayList();
    protected List<Boolean> filterNulls = Lists.newArrayList();
    private final double joinRowFactor;

    public DrillJoinRelBase(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) {
        super(cluster, traits, left, right, condition, (Set)CorrelationId.setOf(Collections.emptySet()), joinType);
        this.joinRowFactor = PrelUtil.getPlannerSettings(cluster.getPlanner()).getRowCountEstimateFactor();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        JoinUtils.JoinCategory category = JoinUtils.getJoinCategory(this.left, this.right, this.condition, this.leftKeys, this.rightKeys, this.filterNulls);
        if (category == JoinUtils.JoinCategory.CARTESIAN || category == JoinUtils.JoinCategory.INEQUALITY) {
            if (PrelUtil.getPlannerSettings(planner).isNestedLoopJoinEnabled()) {
                if (PrelUtil.getPlannerSettings(planner).isNlJoinForScalarOnly()) {
                    if (JoinUtils.hasScalarSubqueryInput(this.left, this.right)) {
                        return this.computeLogicalJoinCost(planner, mq);
                    }
                    if (PrelUtil.getPlannerSettings(planner).isHepOptEnabled()) {
                        return this.computeCartesianJoinCost(planner, mq);
                    }
                    return planner.getCostFactory().makeInfiniteCost();
                }
                return this.computeLogicalJoinCost(planner, mq);
            }
            return planner.getCostFactory().makeInfiniteCost();
        }
        return this.computeLogicalJoinCost(planner, mq);
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        List<Pair<Integer, Integer>> joinConditions;
        if (this.condition.isAlwaysTrue()) {
            return this.joinRowFactor * this.getLeft().estimateRowCount(mq) * this.getRight().estimateRowCount(mq);
        }
        LogicalJoin jr = LogicalJoin.create((RelNode)this.getLeft(), (RelNode)this.getRight(), Collections.emptyList(), (RexNode)this.getCondition(), (Set)this.getVariablesSet(), (JoinRelType)this.getJoinType());
        if (!DrillRelOptUtil.guessRows(this) && jr.getJoinType() == JoinRelType.INNER && (joinConditions = DrillRelOptUtil.analyzeSimpleEquiJoin((Join)jr)).size() > 0) {
            ArrayList<Integer> leftSide = new ArrayList<Integer>();
            ArrayList<Integer> rightSide = new ArrayList<Integer>();
            for (Pair<Integer, Integer> condition : joinConditions) {
                leftSide.add((Integer)condition.left);
                rightSide.add((Integer)condition.right);
            }
            ImmutableBitSet leq = ImmutableBitSet.of(leftSide);
            ImmutableBitSet req = ImmutableBitSet.of(rightSide);
            Double ldrc = mq.getDistinctRowCount(this.getLeft(), leq, null);
            Double rdrc = mq.getDistinctRowCount(this.getRight(), req, null);
            Double lrc = mq.getRowCount(this.getLeft());
            Double rrc = mq.getRowCount(this.getRight());
            if (ldrc != null && rdrc != null && lrc != null && rrc != null) {
                return lrc / Math.max(ldrc, rdrc) * rrc;
            }
        }
        return this.joinRowFactor * Math.max(mq.getRowCount(this.getLeft()), mq.getRowCount(this.getRight()));
    }

    private static <T> boolean intersects(List<T> left, List<T> right) {
        return new HashSet<T>(left).removeAll(right);
    }

    public static boolean uniqueFieldNames(RelDataType rowType) {
        return DrillJoinRelBase.isUnique(rowType.getFieldNames());
    }

    public static <T> boolean isUnique(List<T> list) {
        return new HashSet<T>(list).size() == list.size();
    }

    @Override
    public List<Integer> getLeftKeys() {
        return this.leftKeys;
    }

    @Override
    public List<Integer> getRightKeys() {
        return this.rightKeys;
    }

    protected RelOptCost computeCartesianJoinCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double probeRowCount = mq.getRowCount(this.getLeft());
        double buildRowCount = mq.getRowCount(this.getRight());
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        double mulFactor = 10000.0;
        boolean keySize = true;
        DrillCostBase cost = (DrillCostBase)this.computeHashJoinCostWithKeySize(planner, 1, mq).multiplyBy(10000.0);
        return costFactory.makeCost(buildRowCount * probeRowCount, cost.getCpu(), cost.getIo(), cost.getNetwork(), cost.getMemory());
    }

    protected RelOptCost computeLogicalJoinCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return this.computeHashJoinCost(planner, mq);
    }

    protected RelOptCost computeHashJoinCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return this.computeHashJoinCostWithKeySize(planner, this.getLeftKeys().size(), mq);
    }

    private RelOptCost computeHashJoinCostWithKeySize(RelOptPlanner planner, int keySize, RelMetadataQuery mq) {
        double probeRowCount = mq.getRowCount(this.getLeft());
        double buildRowCount = mq.getRowCount(this.getRight());
        return DrillJoinRelBase.computeHashJoinCostWithRowCntKeySize(planner, probeRowCount, buildRowCount, keySize);
    }

    public static RelOptCost computeHashJoinCostWithRowCntKeySize(RelOptPlanner planner, double probeRowCount, double buildRowCount, int keySize) {
        double cpuCostBuild = (double)(8 * keySize) * buildRowCount;
        double cpuCostProbe = (double)(8 * keySize) * probeRowCount;
        double joinConditionCost = 4 * keySize;
        double factor = PrelUtil.getPlannerSettings((RelOptPlanner)planner).getOptions().getOption((String)"planner.memory.hash_join_table_factor").float_val;
        long fieldWidth = PrelUtil.getPlannerSettings((RelOptPlanner)planner).getOptions().getOption((String)"planner.memory.average_field_width").num_val;
        double memCost = (double)(fieldWidth * (long)keySize + 4L + 4L) * buildRowCount * factor;
        double cpuCost = joinConditionCost * probeRowCount + cpuCostBuild + cpuCostProbe;
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(buildRowCount + probeRowCount, cpuCost, 0.0, 0.0, memCost);
    }
}

