/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.NumberUtil;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.planner.common.DrillRelNode;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.physical.PrelUtil;

public abstract class DrillFilterRelBase
extends Filter
implements DrillRelNode {
    private final int numConjuncts;
    private final List<RexNode> conjunctions;
    private final double filterMinSelectivityEstimateFactor;
    private final double filterMaxSelectivityEstimateFactor;

    protected DrillFilterRelBase(Convention convention, RelOptCluster cluster, RelTraitSet traits, RelNode child, RexNode condition) {
        super(cluster, traits, child, condition);
        assert (this.getConvention() == convention);
        this.conjunctions = RelOptUtil.conjunctions((RexNode)RexUtil.expandSearch((RexBuilder)cluster.getRexBuilder(), null, (RexNode)condition));
        this.numConjuncts = this.conjunctions.size();
        this.filterMinSelectivityEstimateFactor = PrelUtil.getPlannerSettings(cluster.getPlanner()).getFilterMinSelectivityEstimateFactor();
        this.filterMaxSelectivityEstimateFactor = PrelUtil.getPlannerSettings(cluster.getPlanner()).getFilterMaxSelectivityEstimateFactor();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        RelNode child = this.getInput();
        double inputRows = mq.getRowCount(child);
        double cpuCost = this.estimateCpuCost(mq);
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(inputRows, cpuCost, 0.0, 0.0);
    }

    protected LogicalExpression getFilterExpression(DrillParseContext context) {
        return DrillOptiq.toDrill(context, this.getInput(), this.getCondition());
    }

    private double estimateCpuCost(RelMetadataQuery mq) {
        RelNode child = this.getInput();
        double compNum = mq.getRowCount(child);
        for (int i = 0; i < this.numConjuncts; ++i) {
            RexNode conjFilter = RexUtil.composeConjunction((RexBuilder)this.getCluster().getRexBuilder(), this.conjunctions.subList(0, i + 1), (boolean)false);
            compNum += RelMdUtil.estimateFilteredRows((RelNode)child, (RexNode)conjFilter, (RelMetadataQuery)mq);
        }
        return compNum * 4.0;
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        double selectivity = mq.getSelectivity(this.getInput(), this.condition);
        if (!this.condition.isAlwaysFalse() && selectivity < this.filterMinSelectivityEstimateFactor) {
            selectivity = this.filterMinSelectivityEstimateFactor;
        }
        if (!this.condition.isAlwaysTrue() && selectivity > this.filterMaxSelectivityEstimateFactor) {
            selectivity = this.filterMaxSelectivityEstimateFactor;
        }
        return NumberUtil.multiply((Double)selectivity, (Double)mq.getRowCount(this.getInput()));
    }
}

