/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;

public class CountToDirectScanUtils {
    public static boolean containsStarOrNotNullInput(AggregateCall aggregateCall, Aggregate aggregate) {
        return aggregateCall.getArgList().isEmpty() || aggregateCall.getArgList().size() == 1 && !((RelDataTypeField)aggregate.getInput().getRowType().getFieldList().get((Integer)aggregateCall.getArgList().get(0))).getType().isNullable();
    }

    public static RelDataType constructDataType(Aggregate aggregateRel, Collection<String> fieldNames) {
        ArrayList<RelDataTypeFieldImpl> fields = new ArrayList<RelDataTypeFieldImpl>();
        int fieldIndex = 0;
        for (String name : fieldNames) {
            RelDataTypeFieldImpl field = new RelDataTypeFieldImpl(name, fieldIndex++, aggregateRel.getCluster().getTypeFactory().createSqlType(SqlTypeName.BIGINT));
            fields.add(field);
        }
        return new RelRecordType(fields);
    }

    public static LinkedHashMap<String, Class<?>> buildSchema(List<String> fieldNames) {
        LinkedHashMap schema = new LinkedHashMap();
        for (String fieldName : fieldNames) {
            schema.put(fieldName, Long.TYPE);
        }
        return schema;
    }

    public static List<RexNode> prepareFieldExpressions(RelDataType rowType) {
        ArrayList<RexNode> expressions = new ArrayList<RexNode>();
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            expressions.add((RexNode)RexInputRef.of((int)i, (RelDataType)rowType));
        }
        return expressions;
    }
}

