/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner;

import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;

public class StarColumnHelper {
    public static final String PREFIX_DELIMITER = "\u00a6\u00a6";
    public static final String PREFIXED_STAR_COLUMN = "\u00a6\u00a6**";

    public static boolean containsStarColumn(RelDataType type) {
        if (!type.isStruct()) {
            return false;
        }
        List fieldNames = type.getFieldNames();
        for (String fieldName : fieldNames) {
            if (!"**".equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsStarColumnInProject(RelDataType inputRowType, List<RexNode> projExprs) {
        if (!inputRowType.isStruct()) {
            return false;
        }
        for (RexNode expr : projExprs) {
            String name;
            if (!(expr instanceof RexInputRef) || !"**".equals(name = (String)inputRowType.getFieldNames().get(((RexInputRef)expr).getIndex()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrefixedStarColumn(String fieldName) {
        return fieldName.indexOf(PREFIXED_STAR_COLUMN) > 0;
    }

    public static boolean isNonPrefixedStarColumn(String fieldName) {
        return "**".equals(fieldName);
    }

    public static boolean isStarColumn(String fieldName) {
        return StarColumnHelper.isPrefixedStarColumn(fieldName) || StarColumnHelper.isNonPrefixedStarColumn(fieldName);
    }

    public static boolean isRegularColumnOrExp(String fieldName) {
        return !StarColumnHelper.isStarColumn(fieldName);
    }

    public static String extractStarColumnPrefix(String fieldName) {
        assert (StarColumnHelper.isPrefixedStarColumn(fieldName));
        return fieldName.substring(0, fieldName.indexOf(PREFIXED_STAR_COLUMN));
    }

    public static String extractColumnPrefix(String fieldName) {
        if (fieldName.indexOf(PREFIX_DELIMITER) >= 0) {
            return fieldName.substring(0, fieldName.indexOf(PREFIX_DELIMITER));
        }
        return "";
    }

    public static boolean subsumeColumn(Map<String, String> prefixMap, String fieldName) {
        String prefix = StarColumnHelper.extractColumnPrefix(fieldName);
        if (StarColumnHelper.isRegularColumnOrExp(fieldName)) {
            return false;
        }
        return prefixMap.containsKey(prefix) && !fieldName.equals(prefixMap.get(prefix));
    }
}

