/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.util.Set;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.config.LogicalPlanPersistence;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.coord.DrillbitEndpointSerDe;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentLeaf;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalOperatorUtil;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.record.MajorTypeSerDe;
import org.apache.drill.exec.serialization.PathSerDe;
import org.apache.drill.exec.server.options.OptionList;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.pojo.DynamicPojoRecordReader;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalPlanReader {
    private static final Logger logger = LoggerFactory.getLogger(PhysicalPlanReader.class);
    private final ObjectReader physicalPlanReader;
    private final ObjectMapper mapper;
    private final ObjectReader operatorReader;
    private final ObjectReader logicalPlanReader;

    public PhysicalPlanReader(DrillConfig config, ScanResult scanResult, LogicalPlanPersistence lpPersistance, CoordinationProtos.DrillbitEndpoint endpoint, StoragePluginRegistry pluginRegistry) {
        ObjectMapper lpMapper = lpPersistance.getMapper();
        SimpleModule serDeModule = new SimpleModule("PhysicalOperatorModule").addSerializer(CoordinationProtos.DrillbitEndpoint.class, (JsonSerializer)new DrillbitEndpointSerDe.Se()).addDeserializer(CoordinationProtos.DrillbitEndpoint.class, (JsonDeserializer)new DrillbitEndpointSerDe.De()).addSerializer(TypeProtos.MajorType.class, (JsonSerializer)new MajorTypeSerDe.Se()).addDeserializer(TypeProtos.MajorType.class, (JsonDeserializer)new MajorTypeSerDe.De()).addDeserializer(DynamicPojoRecordReader.class, (JsonDeserializer)new StdDelegatingDeserializer((Converter)new DynamicPojoRecordReader.Converter(lpMapper))).addSerializer(Path.class, (JsonSerializer)new PathSerDe.Se());
        lpMapper.registerModule((Module)serDeModule);
        Set<Class<? extends PhysicalOperator>> subTypes = PhysicalOperatorUtil.getSubTypes(scanResult);
        subTypes.forEach(xva$0 -> lpMapper.registerSubtypes(new Class[]{xva$0}));
        lpMapper.registerSubtypes(new Class[]{DynamicPojoRecordReader.class});
        InjectableValues.Std injectables = new InjectableValues.Std().addValue(StoragePluginRegistry.class, (Object)pluginRegistry).addValue(DrillConfig.class, (Object)config).addValue(CoordinationProtos.DrillbitEndpoint.class, (Object)endpoint);
        this.mapper = lpMapper;
        this.physicalPlanReader = this.mapper.readerFor(PhysicalPlan.class).with((InjectableValues)injectables);
        this.operatorReader = this.mapper.readerFor(PhysicalOperator.class).with((InjectableValues)injectables);
        this.logicalPlanReader = this.mapper.readerFor(LogicalPlan.class).with((InjectableValues)injectables);
    }

    public String writeJson(OptionList list) throws JsonProcessingException {
        return this.mapper.writeValueAsString((Object)list);
    }

    public String writeJson(PhysicalOperator op) throws JsonProcessingException {
        return this.mapper.writeValueAsString((Object)op);
    }

    public PhysicalPlan readPhysicalPlan(String json) throws IOException {
        logger.debug("Reading physical plan {}", (Object)json);
        return (PhysicalPlan)this.physicalPlanReader.readValue(json);
    }

    public FragmentRoot readFragmentRoot(String json) throws IOException {
        logger.debug("Attempting to read {}", (Object)json);
        PhysicalOperator op = (PhysicalOperator)this.operatorReader.readValue(json);
        if (op instanceof FragmentRoot) {
            return (FragmentRoot)op;
        }
        throw new UnsupportedOperationException(String.format("The provided json fragment doesn't have a FragmentRoot as its root operator. The operator was %s.", op.getClass().getCanonicalName()));
    }

    @VisibleForTesting
    public FragmentLeaf readFragmentLeaf(String json) throws IOException {
        logger.debug("Attempting to read {}", (Object)json);
        PhysicalOperator op = (PhysicalOperator)this.operatorReader.readValue(json);
        if (op instanceof FragmentLeaf) {
            return (FragmentLeaf)op;
        }
        throw new UnsupportedOperationException(String.format("The provided json fragment is not a FragmentLeaf. The operator was %s.", op.getClass().getCanonicalName()));
    }

    public LogicalPlan readLogicalPlan(String json) throws IOException {
        logger.debug("Reading logical plan {}", (Object)json);
        return (LogicalPlan)this.logicalPlanReader.readValue(json);
    }
}

