/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.util.BitSets;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.AbstractPartitionDescriptor;
import org.apache.drill.exec.planner.ParquetPartitionLocation;
import org.apache.drill.exec.planner.PartitionLocation;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.exec.store.dfs.MetadataContext;
import org.apache.drill.exec.store.parquet.AbstractParquetGroupScan;
import org.apache.drill.exec.store.parquet.ParquetReaderUtility;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.apache.drill.exec.vector.NullableBitVector;
import org.apache.drill.exec.vector.NullableDateVector;
import org.apache.drill.exec.vector.NullableFloat4Vector;
import org.apache.drill.exec.vector.NullableFloat8Vector;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.exec.vector.NullableIntervalVector;
import org.apache.drill.exec.vector.NullableSmallIntVector;
import org.apache.drill.exec.vector.NullableTimeStampVector;
import org.apache.drill.exec.vector.NullableTimeVector;
import org.apache.drill.exec.vector.NullableTinyIntVector;
import org.apache.drill.exec.vector.NullableUInt1Vector;
import org.apache.drill.exec.vector.NullableUInt2Vector;
import org.apache.drill.exec.vector.NullableUInt4Vector;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.NullableVarDecimalVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.primitives.Ints;
import org.apache.drill.shaded.guava.com.google.common.primitives.Longs;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetPartitionDescriptor
extends AbstractPartitionDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(ParquetPartitionDescriptor.class);
    private final DrillScanRel scanRel;
    private final AbstractParquetGroupScan groupScan;
    private final List<SchemaPath> partitionColumns;

    public ParquetPartitionDescriptor(PlannerSettings settings, DrillScanRel scanRel) {
        this.scanRel = scanRel;
        assert (scanRel.getGroupScan() instanceof AbstractParquetGroupScan);
        this.groupScan = (AbstractParquetGroupScan)scanRel.getGroupScan();
        this.partitionColumns = this.groupScan.getPartitionColumns();
    }

    @Override
    public int getPartitionHierarchyIndex(String partitionName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPartitionName(String name) {
        return this.partitionColumns.contains(SchemaPath.getSimplePath(name));
    }

    @Override
    public Integer getIdIfValid(String name) {
        SchemaPath schemaPath = SchemaPath.getSimplePath(name);
        int id = this.partitionColumns.indexOf(schemaPath);
        if (id == -1) {
            return null;
        }
        return id;
    }

    @Override
    public int getMaxHierarchyLevel() {
        return this.partitionColumns.size();
    }

    @Override
    public void populatePartitionVectors(ValueVector[] vectors, List<PartitionLocation> partitions, BitSet partitionColumnBitSet, Map<Integer, String> fieldNameMap) {
        int record = 0;
        for (PartitionLocation partitionLocation : partitions) {
            Iterator iterator = BitSets.toIter((BitSet)partitionColumnBitSet).iterator();
            while (iterator.hasNext()) {
                int partitionColumnIndex = (Integer)iterator.next();
                SchemaPath column = SchemaPath.getSimplePath(fieldNameMap.get(partitionColumnIndex));
                this.populatePruningVector(vectors[partitionColumnIndex], record, column, partitionLocation.getEntirePartitionLocation());
            }
            ++record;
        }
        for (ValueVector v : vectors) {
            if (v == null) continue;
            v.getMutator().setValueCount(partitions.size());
        }
    }

    @Override
    public TypeProtos.MajorType getVectorType(SchemaPath column, PlannerSettings plannerSettings) {
        return this.groupScan.getTypeForColumn(column);
    }

    @Override
    public Path getBaseTableLocation() {
        FormatSelection origSelection = (FormatSelection)this.scanRel.getDrillTable().getSelection();
        return origSelection.getSelection().selectionRoot;
    }

    @Override
    public TableScan createTableScan(List<PartitionLocation> newPartitionLocation, Path cacheFileRoot, boolean wasAllPartitionsPruned, MetadataContext metaContext) throws Exception {
        ArrayList<Path> newFiles = new ArrayList<Path>();
        for (PartitionLocation location : newPartitionLocation) {
            newFiles.add(location.getEntirePartitionLocation());
        }
        GroupScan newGroupScan = this.createNewGroupScan(newFiles, cacheFileRoot, wasAllPartitionsPruned, metaContext);
        if (newGroupScan == null) {
            logger.warn("Unable to create new group scan, returning original table scan.");
            return this.scanRel;
        }
        return new DrillScanRel(this.scanRel.getCluster(), this.scanRel.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), this.scanRel.getTable(), newGroupScan, this.scanRel.getRowType(), this.scanRel.getColumns(), true);
    }

    @Override
    public TableScan createTableScan(List<PartitionLocation> newPartitionLocation, boolean wasAllPartitionsPruned) throws Exception {
        return this.createTableScan(newPartitionLocation, null, wasAllPartitionsPruned, null);
    }

    @Override
    protected void createPartitionSublists() {
        Set<Path> fileLocations = this.groupScan.getFileSet();
        LinkedList<ParquetPartitionLocation> locations = new LinkedList<ParquetPartitionLocation>();
        for (Path file : fileLocations) {
            locations.add(new ParquetPartitionLocation(file));
        }
        this.locationSuperList = Lists.partition(locations, 65535);
        this.sublistsCreated = true;
    }

    private GroupScan createNewGroupScan(List<Path> newFiles, Path cacheFileRoot, boolean wasAllPartitionsPruned, MetadataContext metaContext) throws IOException {
        FileSelection newSelection = FileSelection.create(null, newFiles, this.getBaseTableLocation(), cacheFileRoot, wasAllPartitionsPruned);
        if (newSelection == null) {
            return null;
        }
        newSelection.setMetaContext(metaContext);
        return this.groupScan.clone(newSelection);
    }

    private void populatePruningVector(ValueVector v, int index, SchemaPath column, Path file) {
        Path path = Path.getPathWithoutSchemeAndAuthority((Path)file);
        TypeProtos.MajorType majorType = this.getVectorType(column, null);
        TypeProtos.MinorType type = majorType.getMinorType();
        switch (type) {
            case BIT: {
                NullableBitVector bitVector = (NullableBitVector)v;
                Boolean value = this.groupScan.getPartitionValue(path, column, Boolean.class);
                if (value == null) {
                    bitVector.getMutator().setNull(index);
                } else {
                    bitVector.getMutator().setSafe(index, value != false ? 1 : 0);
                }
                return;
            }
            case INT: {
                NullableIntVector intVector = (NullableIntVector)v;
                Integer value = this.groupScan.getPartitionValue(path, column, Integer.class);
                if (value == null) {
                    intVector.getMutator().setNull(index);
                } else {
                    intVector.getMutator().setSafe(index, value);
                }
                return;
            }
            case SMALLINT: {
                NullableSmallIntVector smallIntVector = (NullableSmallIntVector)v;
                Integer value = this.groupScan.getPartitionValue(path, column, Integer.class);
                if (value == null) {
                    smallIntVector.getMutator().setNull(index);
                } else {
                    smallIntVector.getMutator().setSafe(index, value.shortValue());
                }
                return;
            }
            case TINYINT: {
                NullableTinyIntVector tinyIntVector = (NullableTinyIntVector)v;
                Integer value = this.groupScan.getPartitionValue(path, column, Integer.class);
                if (value == null) {
                    tinyIntVector.getMutator().setNull(index);
                } else {
                    tinyIntVector.getMutator().setSafe(index, value.byteValue());
                }
                return;
            }
            case UINT1: {
                NullableUInt1Vector intVector = (NullableUInt1Vector)v;
                Integer value = this.groupScan.getPartitionValue(path, column, Integer.class);
                if (value == null) {
                    intVector.getMutator().setNull(index);
                } else {
                    intVector.getMutator().setSafe(index, value.byteValue());
                }
                return;
            }
            case UINT2: {
                NullableUInt2Vector intVector = (NullableUInt2Vector)v;
                Integer value = this.groupScan.getPartitionValue(path, column, Integer.class);
                if (value == null) {
                    intVector.getMutator().setNull(index);
                } else {
                    intVector.getMutator().setSafe(index, (char)value.shortValue());
                }
                return;
            }
            case UINT4: {
                NullableUInt4Vector intVector = (NullableUInt4Vector)v;
                Integer value = this.groupScan.getPartitionValue(path, column, Integer.class);
                if (value == null) {
                    intVector.getMutator().setNull(index);
                } else {
                    intVector.getMutator().setSafe(index, value);
                }
                return;
            }
            case BIGINT: {
                NullableBigIntVector bigIntVector = (NullableBigIntVector)v;
                Long value = this.groupScan.getPartitionValue(path, column, Long.class);
                if (value == null) {
                    bigIntVector.getMutator().setNull(index);
                } else {
                    bigIntVector.getMutator().setSafe(index, value);
                }
                return;
            }
            case FLOAT4: {
                NullableFloat4Vector float4Vector = (NullableFloat4Vector)v;
                Float value = this.groupScan.getPartitionValue(path, column, Float.class);
                if (value == null) {
                    float4Vector.getMutator().setNull(index);
                } else {
                    float4Vector.getMutator().setSafe(index, value.floatValue());
                }
                return;
            }
            case FLOAT8: {
                NullableFloat8Vector float8Vector = (NullableFloat8Vector)v;
                Double value = this.groupScan.getPartitionValue(path, column, Double.class);
                if (value == null) {
                    float8Vector.getMutator().setNull(index);
                } else {
                    float8Vector.getMutator().setSafe(index, value);
                }
                return;
            }
            case VARBINARY: {
                NullableVarBinaryVector varBinaryVector = (NullableVarBinaryVector)v;
                Object s = this.groupScan.getPartitionValue(path, column, Object.class);
                if (s == null) {
                    varBinaryVector.getMutator().setNull(index);
                    return;
                }
                byte[] bytes = this.getBytes(type, s);
                varBinaryVector.getMutator().setSafe(index, bytes, 0, bytes.length);
                return;
            }
            case VARDECIMAL: {
                NullableVarDecimalVector decimalVector = (NullableVarDecimalVector)v;
                Object s = this.groupScan.getPartitionValue(path, column, Object.class);
                if (s == null) {
                    decimalVector.getMutator().setNull(index);
                    return;
                }
                byte[] bytes = s instanceof Integer ? Ints.toByteArray((Integer)s) : (s instanceof Long ? Longs.toByteArray((Long)s) : this.getBytes(type, s));
                decimalVector.getMutator().setSafe(index, bytes, 0, bytes.length);
                return;
            }
            case DATE: {
                NullableDateVector dateVector = (NullableDateVector)v;
                Long value = this.groupScan.getPartitionValue(path, column, Long.class);
                if (value == null) {
                    dateVector.getMutator().setNull(index);
                } else {
                    dateVector.getMutator().setSafe(index, value);
                }
                return;
            }
            case TIME: {
                NullableTimeVector timeVector = (NullableTimeVector)v;
                Integer value = this.groupScan.getPartitionValue(path, column, Integer.class);
                if (value == null) {
                    timeVector.getMutator().setNull(index);
                } else {
                    timeVector.getMutator().setSafe(index, value);
                }
                return;
            }
            case TIMESTAMP: {
                NullableTimeStampVector timeStampVector = (NullableTimeStampVector)v;
                Long value = this.groupScan.getPartitionValue(path, column, Long.class);
                if (value == null) {
                    timeStampVector.getMutator().setNull(index);
                } else {
                    timeStampVector.getMutator().setSafe(index, value);
                }
                return;
            }
            case VARCHAR: {
                NullableVarCharVector varCharVector = (NullableVarCharVector)v;
                Object s = this.groupScan.getPartitionValue(path, column, Object.class);
                if (s == null) {
                    varCharVector.getMutator().setNull(index);
                    return;
                }
                byte[] bytes = this.getBytes(type, s);
                varCharVector.getMutator().setSafe(index, bytes, 0, bytes.length);
                return;
            }
            case INTERVAL: {
                NullableIntervalVector intervalVector = (NullableIntervalVector)v;
                Object s = this.groupScan.getPartitionValue(path, column, Object.class);
                if (s == null) {
                    intervalVector.getMutator().setNull(index);
                    return;
                }
                byte[] bytes = this.getBytes(type, s);
                intervalVector.getMutator().setSafe(index, 1, ParquetReaderUtility.getIntFromLEBytes(bytes, 0), ParquetReaderUtility.getIntFromLEBytes(bytes, 4), ParquetReaderUtility.getIntFromLEBytes(bytes, 8));
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private byte[] getBytes(TypeProtos.MinorType type, Object source) {
        byte[] bytes;
        if (source instanceof String) {
            bytes = ((String)source).getBytes(StandardCharsets.UTF_8);
        } else if (source instanceof byte[]) {
            bytes = (byte[])source;
        } else {
            throw new UnsupportedOperationException("Unable to create column data for type: " + type);
        }
        return bytes;
    }
}

