/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.Table;
import org.apache.calcite.util.BitSets;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.GuavaUtils;
import org.apache.drill.exec.physical.base.FileGroupScan;
import org.apache.drill.exec.planner.AbstractPartitionDescriptor;
import org.apache.drill.exec.planner.DFSDirPartitionLocation;
import org.apache.drill.exec.planner.DFSFilePartitionLocation;
import org.apache.drill.exec.planner.PartitionLocation;
import org.apache.drill.exec.planner.SimplePartitionLocation;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillTranslatableTable;
import org.apache.drill.exec.planner.logical.DynamicDrillTable;
import org.apache.drill.exec.planner.logical.SelectionBasedTableScan;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.exec.store.dfs.MetadataContext;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.hadoop.fs.Path;

public class FileSystemPartitionDescriptor
extends AbstractPartitionDescriptor {
    static final int MAX_NESTED_SUBDIRS = 10;
    private final String partitionLabel;
    private final int partitionLabelLength;
    private final Map<String, Integer> partitions = new HashMap<String, Integer>();
    private final TableScan scanRel;
    private final DrillTable table;

    public FileSystemPartitionDescriptor(PlannerSettings settings, TableScan scanRel) {
        Preconditions.checkArgument(scanRel instanceof DrillScanRel || FileSystemPartitionDescriptor.supportsScan(scanRel));
        this.partitionLabel = settings.getFsPartitionColumnLabel();
        this.partitionLabelLength = this.partitionLabel.length();
        this.scanRel = scanRel;
        DrillTable unwrap = (DrillTable)scanRel.getTable().unwrap(DrillTable.class);
        if (unwrap == null) {
            unwrap = ((DrillTranslatableTable)scanRel.getTable().unwrap(DrillTranslatableTable.class)).getDrillTable();
        }
        this.table = unwrap;
        for (int i = 0; i < 10; ++i) {
            this.partitions.put(this.partitionLabel + i, i);
        }
    }

    @Override
    public int getPartitionHierarchyIndex(String partitionName) {
        String suffix = partitionName.substring(this.partitionLabelLength);
        return Integer.parseInt(suffix);
    }

    @Override
    public boolean isPartitionName(String name) {
        return this.partitions.containsKey(name);
    }

    @Override
    public Integer getIdIfValid(String name) {
        return this.partitions.get(name);
    }

    @Override
    public int getMaxHierarchyLevel() {
        return 10;
    }

    public DrillTable getTable() {
        return this.table;
    }

    @Override
    public void populatePartitionVectors(ValueVector[] vectors, List<PartitionLocation> partitions, BitSet partitionColumnBitSet, Map<Integer, String> fieldNameMap) {
        int record = 0;
        for (PartitionLocation partitionLocation : partitions) {
            Iterator iterator = BitSets.toIter((BitSet)partitionColumnBitSet).iterator();
            while (iterator.hasNext()) {
                int partitionColumnIndex = (Integer)iterator.next();
                if (partitionLocation.getPartitionValue(partitionColumnIndex) == null) {
                    ((NullableVarCharVector)vectors[partitionColumnIndex]).getMutator().setNull(record);
                    continue;
                }
                byte[] bytes = partitionLocation.getPartitionValue(partitionColumnIndex).getBytes(Charsets.UTF_8);
                ((NullableVarCharVector)vectors[partitionColumnIndex]).getMutator().setSafe(record, bytes, 0, bytes.length);
            }
            ++record;
        }
        for (ValueVector v : vectors) {
            if (v == null) continue;
            v.getMutator().setValueCount(partitions.size());
        }
    }

    @Override
    public TypeProtos.MajorType getVectorType(SchemaPath column, PlannerSettings plannerSettings) {
        return Types.optional(TypeProtos.MinorType.VARCHAR);
    }

    public String getName(int index) {
        return this.partitionLabel + index;
    }

    @Override
    public Path getBaseTableLocation() {
        FormatSelection origSelection = (FormatSelection)this.table.getSelection();
        return origSelection.getSelection().getSelectionRoot();
    }

    @Override
    protected void createPartitionSublists() {
        Pair<Collection<Path>, Boolean> fileLocationsAndStatus = this.getFileLocationsAndStatus();
        LinkedList locations = new LinkedList();
        boolean hasDirsOnly = (Boolean)fileLocationsAndStatus.getRight();
        Path selectionRoot = this.getBaseTableLocation();
        HashMap dirToFileMap = new HashMap();
        for (Path file : (Collection)fileLocationsAndStatus.getLeft()) {
            DFSFilePartitionLocation dfsFilePartitionLocation = new DFSFilePartitionLocation(10, selectionRoot, file, hasDirsOnly);
            List<String> dirList = Arrays.asList(dfsFilePartitionLocation.getDirs());
            dirToFileMap.putIfAbsent(dirList, new ArrayList());
            ((List)dirToFileMap.get(dirList)).add(dfsFilePartitionLocation);
        }
        dirToFileMap.keySet().stream().map(dirs -> new DFSDirPartitionLocation(dirs.toArray(new String[dirs.size()]), (Collection)dirToFileMap.get(dirs))).forEach(locations::add);
        this.locationSuperList = Lists.partition(locations, 65535);
        this.sublistsCreated = true;
    }

    protected Pair<Collection<Path>, Boolean> getFileLocationsAndStatus() {
        Collection<Path> fileLocations = null;
        boolean isExpandedPartial = false;
        if (this.scanRel instanceof DrillScanRel) {
            DrillScanRel drillScan = (DrillScanRel)this.scanRel;
            if (drillScan.getGroupScan().hasFiles()) {
                fileLocations = drillScan.getGroupScan().getFiles();
                isExpandedPartial = false;
            } else {
                FileSelection selection = ((FormatSelection)this.table.getSelection()).getSelection();
                fileLocations = selection.getFiles();
                isExpandedPartial = selection.isExpandedPartial();
            }
        } else if (FileSystemPartitionDescriptor.supportsScan(this.scanRel)) {
            FileSelection selection = ((FormatSelection)this.table.getSelection()).getSelection();
            fileLocations = selection.getFiles();
            isExpandedPartial = selection.isExpandedPartial();
        }
        return Pair.of(fileLocations, (Object)isExpandedPartial);
    }

    @Override
    public TableScan createTableScan(List<PartitionLocation> newPartitionLocation, Path cacheFileRoot, boolean wasAllPartitionsPruned, MetadataContext metaContext) throws Exception {
        ArrayList<Path> newFiles = new ArrayList<Path>();
        for (PartitionLocation location : newPartitionLocation) {
            if (!location.isCompositePartition()) {
                newFiles.add(location.getEntirePartitionLocation());
                continue;
            }
            List<SimplePartitionLocation> subPartitions = location.getPartitionLocationRecursive();
            for (PartitionLocation partitionLocation : subPartitions) {
                newFiles.add(partitionLocation.getEntirePartitionLocation());
            }
        }
        FormatSelection formatSelection = (FormatSelection)this.table.getSelection();
        FileSelection newFileSelection = new FileSelection(null, newFiles, this.getBaseTableLocation(), cacheFileRoot, wasAllPartitionsPruned, formatSelection.getSelection().getDirStatus());
        newFileSelection.setMetaContext(metaContext);
        RelOptTable relOptTable = this.scanRel.getTable();
        if (this.scanRel instanceof DrillScanRel) {
            FileGroupScan newGroupScan = ((FileGroupScan)((DrillScanRel)this.scanRel).getGroupScan()).clone(newFileSelection);
            return new DrillScanRel(this.scanRel.getCluster(), this.scanRel.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), relOptTable, newGroupScan, this.scanRel.getRowType(), ((DrillScanRel)this.scanRel).getColumns(), true);
        }
        if (FileSystemPartitionDescriptor.supportsScan(this.scanRel)) {
            FormatSelection newFormatSelection = new FormatSelection(formatSelection.getFormat(), newFileSelection);
            DynamicDrillTable dynamicDrillTable = new DynamicDrillTable(this.table.getPlugin(), this.table.getStorageEngineName(), this.table.getUserName(), newFormatSelection, this.table.getMetadataProviderManager());
            DrillTranslatableTable newTable = new DrillTranslatableTable(dynamicDrillTable);
            RelOptTableImpl newOptTableImpl = RelOptTableImpl.create((RelOptSchema)relOptTable.getRelOptSchema(), (RelDataType)relOptTable.getRowType(), (Table)newTable, GuavaUtils.convertToUnshadedImmutableList(relOptTable.getQualifiedName()));
            return SelectionBasedTableScan.create(this.scanRel.getCluster(), (RelOptTable)newOptTableImpl, newFileSelection.toString());
        }
        throw new UnsupportedOperationException("Only DrillScanRel and DirPrunedTableScan is allowed!");
    }

    @Override
    public TableScan createTableScan(List<PartitionLocation> newPartitionLocation, boolean wasAllPartitionsPruned) throws Exception {
        return this.createTableScan(newPartitionLocation, null, wasAllPartitionsPruned, null);
    }

    @Override
    public boolean supportsMetadataCachePruning() {
        Object selection = this.table.getSelection();
        return selection instanceof FormatSelection && ((FormatSelection)selection).getSelection().getCacheFileRoot() != null;
    }

    private static boolean supportsScan(TableScan scanRel) {
        return scanRel instanceof SelectionBasedTableScan;
    }
}

