/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner;

import org.apache.drill.exec.planner.SimplePartitionLocation;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.hadoop.fs.Path;

public class DFSFilePartitionLocation
extends SimplePartitionLocation {
    private final String[] dirs;
    private final Path file;

    public DFSFilePartitionLocation(int max, Path selectionRoot, Path file, boolean hasDirsOnly) {
        this.file = file;
        this.dirs = new String[max];
        String[] dirs = ColumnExplorer.parsePartitions(this.file, selectionRoot, hasDirsOnly);
        System.arraycopy(dirs, 0, this.dirs, 0, Math.min(max, dirs.length));
    }

    @Override
    public String getPartitionValue(int index) {
        assert (index < this.dirs.length);
        return this.dirs[index];
    }

    @Override
    public Path getEntirePartitionLocation() {
        return this.file;
    }

    public String[] getDirs() {
        return this.dirs;
    }
}

