/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.rowSet;

import org.apache.drill.exec.physical.impl.protocol.BatchAccessor;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.HyperRowSetImpl;
import org.apache.drill.exec.physical.rowSet.IndirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;

public class RowSets {
    public static RowSet wrap(RecordBatch batch) {
        VectorContainer container = batch.getContainer();
        switch (container.getSchema().getSelectionVectorMode()) {
            case FOUR_BYTE: {
                return HyperRowSetImpl.fromContainer(container, batch.getSelectionVector4());
            }
            case NONE: {
                return DirectRowSet.fromContainer(container);
            }
            case TWO_BYTE: {
                return IndirectRowSet.fromSv2(container, batch.getSelectionVector2());
            }
        }
        throw new IllegalStateException("Invalid selection mode");
    }

    public static RowSet wrap(VectorContainer container) {
        switch (container.getSchema().getSelectionVectorMode()) {
            case FOUR_BYTE: {
                throw new IllegalArgumentException("Build from a batch for SV4");
            }
            case NONE: {
                return DirectRowSet.fromContainer(container);
            }
            case TWO_BYTE: {
                throw new IllegalArgumentException("Build from a batch for SV2");
            }
        }
        throw new IllegalStateException("Invalid selection mode");
    }

    public static RowSet wrap(BatchAccessor batch) {
        VectorContainer container = batch.container();
        switch (container.getSchema().getSelectionVectorMode()) {
            case FOUR_BYTE: {
                return HyperRowSetImpl.fromContainer(container, batch.selectionVector4());
            }
            case NONE: {
                return DirectRowSet.fromContainer(container);
            }
            case TWO_BYTE: {
                return IndirectRowSet.fromSv2(container, batch.selectionVector2());
            }
        }
        throw new IllegalStateException("Invalid selection mode");
    }
}

