/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.rowSet;

import java.util.List;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetWriter;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import org.apache.drill.exec.vector.accessor.writer.AbstractTupleWriter;

public class RowSetWriterImpl
extends AbstractTupleWriter
implements RowSetWriter {
    private final WriterIndexImpl writerIndex;
    private final RowSet.ExtendableRowSet rowSet;

    protected RowSetWriterImpl(RowSet.ExtendableRowSet rowSet, TupleMetadata schema, WriterIndexImpl index, List<AbstractObjectWriter> writers) {
        super(schema, writers);
        this.rowSet = rowSet;
        this.writerIndex = index;
        this.bindIndex(index);
        this.startWrite();
        this.startRow();
    }

    @Override
    public RowSetWriter addRow(Object ... values) {
        this.setObject(values);
        this.save();
        return this;
    }

    @Override
    public RowSetWriter addSingleCol(Object value) {
        return this.addRow(value);
    }

    @Override
    public int rowIndex() {
        return this.writerIndex.vectorIndex();
    }

    @Override
    public void save() {
        this.endArrayValue();
        this.saveRow();
        if (this.writerIndex.next()) {
            this.startRow();
        }
    }

    @Override
    public boolean isFull() {
        return !this.writerIndex.valid();
    }

    @Override
    public RowSet.SingleRowSet done() {
        this.endWrite();
        this.rowSet.container().setRecordCount(this.writerIndex.vectorIndex());
        return this.rowSet;
    }

    @Override
    public int lastWriteIndex() {
        return this.writerIndex.vectorIndex();
    }

    @Override
    public ColumnMetadata schema() {
        return null;
    }

    static class WriterIndexImpl
    implements ColumnWriterIndex {
        private int rowIndex = 0;
        private State state = State.OK;

        WriterIndexImpl() {
        }

        @Override
        public final int vectorIndex() {
            return this.rowIndex;
        }

        public final boolean next() {
            if (++this.rowIndex < 65536) {
                return true;
            }
            assert (this.rowIndex == 65536);
            this.rowIndex = 65536;
            this.state = this.state == State.OK ? State.END_OF_BATCH : this.state;
            return false;
        }

        public int size() {
            return this.rowIndex;
        }

        public boolean valid() {
            return this.state == State.OK;
        }

        public boolean hasOverflow() {
            return this.state == State.VECTOR_OVERFLOW;
        }

        @Override
        public final void nextElement() {
        }

        @Override
        public final void prevElement() {
        }

        @Override
        public void rollover() {
            throw new UnsupportedOperationException("Rollover not supported in the row set writer.");
        }

        @Override
        public int rowStartIndex() {
            return this.rowIndex;
        }

        @Override
        public ColumnWriterIndex outerIndex() {
            return null;
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " state = " + (Object)((Object)this.state) + ", rowIndex = " + this.rowIndex + "]";
        }

        public static enum State {
            OK,
            VECTOR_OVERFLOW,
            END_OF_BATCH;

        }
    }
}

