/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.rowSet;

import java.util.List;
import org.apache.drill.exec.physical.resultSet.model.ReaderIndex;
import org.apache.drill.exec.physical.rowSet.RowSetReader;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.vector.accessor.reader.AbstractObjectReader;
import org.apache.drill.exec.vector.accessor.reader.AbstractTupleReader;
import org.apache.drill.exec.vector.accessor.reader.NullStateReaders;

public class RowSetReaderImpl
extends AbstractTupleReader
implements RowSetReader {
    private final TupleMetadata schema;
    protected final ReaderIndex readerIndex;

    public RowSetReaderImpl(TupleMetadata schema, ReaderIndex index, AbstractObjectReader[] readers) {
        super(readers);
        this.schema = schema;
        this.readerIndex = index;
        this.bindNullState(NullStateReaders.REQUIRED_STATE_READER);
        this.bindIndex(index);
    }

    public RowSetReaderImpl(TupleMetadata schema, ReaderIndex index, List<AbstractObjectReader> readers) {
        this(schema, index, readers.toArray(new AbstractObjectReader[0]));
    }

    @Override
    public boolean next() {
        if (!this.readerIndex.next()) {
            return false;
        }
        this.reposition();
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.readerIndex.hasNext();
    }

    @Override
    public int logicalIndex() {
        return this.readerIndex.logicalIndex();
    }

    @Override
    public int rowCount() {
        return this.readerIndex.size();
    }

    @Override
    public int offset() {
        return this.readerIndex.offset();
    }

    @Override
    public int hyperVectorIndex() {
        return this.readerIndex.hyperVectorIndex();
    }

    @Override
    public void setPosition(int index) {
        this.readerIndex.set(index);
        this.reposition();
    }

    @Override
    public ColumnMetadata schema() {
        return null;
    }

    @Override
    public TupleMetadata tupleSchema() {
        return this.schema;
    }

    @Override
    public void rewind() {
        this.setPosition(-1);
    }

    @Override
    public void newBatch() {
        this.bindBuffer();
        this.rewind();
    }
}

