/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.rowSet;

import java.util.Collections;
import java.util.Set;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.resultSet.model.single.SingleSchemaInference;
import org.apache.drill.exec.physical.rowSet.AbstractSingleRowSet;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.IndirectRowIndex;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetReader;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatchSizer;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.selection.SelectionVector2;

public class IndirectRowSet
extends AbstractSingleRowSet {
    private final SelectionVector2 sv2;

    private IndirectRowSet(VectorContainer container, SelectionVector2 sv2) {
        super(container, new SingleSchemaInference().infer(container));
        this.sv2 = sv2;
    }

    public IndirectRowSet(VectorContainer container) {
        this(container, IndirectRowSet.makeSv2(container.getAllocator(), container, Collections.emptySet()));
    }

    public IndirectRowSet(DirectRowSet directRowSet, Set<Integer> skipIndices) {
        super(directRowSet);
        this.sv2 = IndirectRowSet.makeSv2(this.allocator(), this.container(), skipIndices);
    }

    public static IndirectRowSet fromContainer(VectorContainer container) {
        return new IndirectRowSet(container, IndirectRowSet.makeSv2(container.getAllocator(), container, Collections.emptySet()));
    }

    public static IndirectRowSet fromSv2(VectorContainer container, SelectionVector2 sv2) {
        return new IndirectRowSet(container, sv2);
    }

    private static SelectionVector2 makeSv2(BufferAllocator allocator, VectorContainer container, Set<Integer> skipIndices) {
        SelectionVector2 sv2 = new SelectionVector2(allocator);
        int rowCount = container.getRecordCount() - skipIndices.size();
        if (!sv2.allocateNewSafe(rowCount)) {
            throw new OutOfMemoryException("Unable to allocate sv2 buffer");
        }
        int destIndex = 0;
        for (int srcIndex = 0; srcIndex < container.getRecordCount(); ++srcIndex) {
            if (skipIndices.contains(srcIndex)) continue;
            sv2.setIndex(destIndex, (char)srcIndex);
            ++destIndex;
        }
        sv2.setRecordCount(rowCount);
        sv2.setBatchActualRecordCount(container.getRecordCount());
        container.buildSchema(BatchSchema.SelectionVectorMode.TWO_BYTE);
        return sv2;
    }

    @Override
    public SelectionVector2 getSv2() {
        return this.sv2;
    }

    @Override
    public void clear() {
        super.clear();
        this.getSv2().clear();
    }

    @Override
    public RowSetReader reader() {
        IndirectRowIndex index = new IndirectRowIndex(this.getSv2());
        return this.buildReader(index);
    }

    @Override
    public boolean isExtendable() {
        return false;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public BatchSchema.SelectionVectorMode indirectionType() {
        return BatchSchema.SelectionVectorMode.TWO_BYTE;
    }

    @Override
    public RowSet.SingleRowSet toIndirect() {
        return this;
    }

    @Override
    public RowSet.SingleRowSet toIndirect(Set<Integer> skipIndices) {
        return new IndirectRowSet(DirectRowSet.fromContainer(this.container()), skipIndices);
    }

    @Override
    public long size() {
        RecordBatchSizer sizer = new RecordBatchSizer(this.container(), this.sv2);
        return sizer.getActualSize();
    }
}

