/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.rowSet;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.resultSet.model.hyper.HyperReaderBuilder;
import org.apache.drill.exec.physical.resultSet.model.hyper.HyperSchemaInference;
import org.apache.drill.exec.physical.rowSet.AbstractRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetReader;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.ExpandableHyperContainer;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.selection.SelectionVector4;

public class HyperRowSetImpl
extends AbstractRowSet
implements RowSet.HyperRowSet {
    private final SelectionVector4 sv4;

    public HyperRowSetImpl(TupleMetadata schema, VectorContainer container, SelectionVector4 sv4) {
        super(container, schema);
        this.sv4 = sv4;
    }

    public HyperRowSetImpl(VectorContainer container, SelectionVector4 sv4) throws SchemaChangeException {
        this(new HyperSchemaInference().infer(container), container, sv4);
    }

    public static RowSet.HyperRowSetBuilder builder(BufferAllocator allocator) {
        return new HyperRowSetBuilderImpl(allocator);
    }

    public static RowSet.HyperRowSet fromContainer(VectorContainer container, SelectionVector4 sv4) {
        try {
            return new HyperRowSetImpl(container, sv4);
        }
        catch (SchemaChangeException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static RowSet.HyperRowSet fromRowSets(BufferAllocator allocator, RowSet.SingleRowSet ... rowSets) {
        RowSet.HyperRowSetBuilder builder = HyperRowSetImpl.builder(allocator);
        for (RowSet.SingleRowSet rowSet : rowSets) {
            builder.addBatch(rowSet);
        }
        try {
            return builder.build();
        }
        catch (SchemaChangeException e) {
            throw new IllegalArgumentException("Incompatible schemas", e);
        }
    }

    @Override
    public boolean isExtendable() {
        return false;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public RowSetReader reader() {
        return HyperReaderBuilder.build(this.container(), this.schema, this.sv4);
    }

    @Override
    public BatchSchema.SelectionVectorMode indirectionType() {
        return BatchSchema.SelectionVectorMode.FOUR_BYTE;
    }

    @Override
    public SelectionVector4 getSv4() {
        return this.sv4;
    }

    @Override
    public int rowCount() {
        return this.sv4.getCount();
    }

    @Override
    public void clear() {
        super.clear();
        this.sv4.clear();
    }

    public static class HyperRowSetBuilderImpl
    implements RowSet.HyperRowSetBuilder {
        private final BufferAllocator allocator;
        private final List<VectorContainer> batches = new ArrayList<VectorContainer>();
        private int totalRowCount;

        public HyperRowSetBuilderImpl(BufferAllocator allocator) {
            this.allocator = allocator;
        }

        @Override
        public void addBatch(RowSet.SingleRowSet rowSet) {
            if (rowSet.rowCount() == 0) {
                return;
            }
            if (rowSet.indirectionType() != BatchSchema.SelectionVectorMode.NONE) {
                throw new IllegalArgumentException("Batches must not have a selection vector.");
            }
            this.batches.add(rowSet.container());
            this.totalRowCount += rowSet.rowCount();
        }

        @Override
        public void addBatch(VectorContainer container) {
            if (container.getRecordCount() == 0) {
                return;
            }
            if (container.getSchema().getSelectionVectorMode() != BatchSchema.SelectionVectorMode.NONE) {
                throw new IllegalArgumentException("Batches must not have a selection vector.");
            }
            this.batches.add(container);
            this.totalRowCount += container.getRecordCount();
        }

        @Override
        public RowSet.HyperRowSet build() throws SchemaChangeException {
            SelectionVector4 sv4 = new SelectionVector4(this.allocator, this.totalRowCount);
            ExpandableHyperContainer hyperContainer = new ExpandableHyperContainer();
            for (VectorContainer container : this.batches) {
                hyperContainer.addBatch(container);
            }
            hyperContainer.setRecordCount(this.totalRowCount);
            TupleMetadata schema = new HyperSchemaInference().infer(hyperContainer);
            return new HyperRowSetImpl(schema, hyperContainer, sv4);
        }
    }
}

