/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.drill.exec.vector.accessor.ArrayReader;
import org.apache.drill.exec.vector.accessor.ObjectReader;
import org.apache.drill.exec.vector.accessor.ScalarReader;
import org.apache.drill.exec.vector.accessor.TupleReader;
import org.apache.drill.exec.vector.complex.fn.BasicJsonOutput;
import org.apache.drill.exec.vector.complex.fn.ExtendedJsonOutput;
import org.apache.drill.exec.vector.complex.fn.JsonOutput;

public class JsonWriter {
    private final JsonOutput gen;

    public JsonWriter(OutputStream out, boolean pretty, boolean useExtendedOutput) throws IOException {
        JsonFactory factory = new JsonFactory();
        JsonGenerator writer = factory.disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM).createGenerator(out);
        writer.setPrettyPrinter((PrettyPrinter)(pretty ? new DefaultPrettyPrinter("\n") : new MinimalPrettyPrinter("\n")));
        this.gen = useExtendedOutput ? new ExtendedJsonOutput(writer) : new BasicJsonOutput(writer);
    }

    public JsonWriter(JsonOutput gen) {
        this.gen = gen;
    }

    public JsonOutput jsonOutput() {
        return this.gen;
    }

    public void writeRow(TupleReader reader) throws IOException {
        this.writeObject(reader);
        this.gen.flush();
    }

    private void writeObject(TupleReader reader) throws IOException {
        this.gen.writeStartObject();
        for (int i = 0; i < reader.tupleSchema().size(); ++i) {
            this.writeColumn(reader.column(i));
        }
        this.gen.writeEndObject();
    }

    private void writeColumn(ObjectReader reader) throws IOException {
        this.gen.writeFieldName(reader.schema().name());
        this.writeValue(reader);
    }

    private void writeValue(ObjectReader reader) throws IOException {
        if (reader.isNull()) {
            this.gen.writeUntypedNull();
            return;
        }
        switch (reader.type()) {
            case ARRAY: {
                this.writeArray(reader.array());
                break;
            }
            case SCALAR: {
                this.writeScalar(reader.scalar());
                break;
            }
            case TUPLE: {
                this.writeObject(reader.tuple());
                break;
            }
            case VARIANT: {
                this.writeColumn(reader.variant().member());
                break;
            }
            default: {
                throw new IllegalStateException(reader.type().name());
            }
        }
    }

    private void writeArray(ArrayReader reader) throws IOException {
        this.gen.writeStartArray();
        ObjectReader entryWriter = reader.entry();
        while (reader.next()) {
            this.writeValue(entryWriter);
        }
        this.gen.writeEndArray();
    }

    private void writeScalar(ScalarReader reader) throws IOException {
        switch (reader.valueType()) {
            case BOOLEAN: {
                this.gen.writeBoolean(reader.getBoolean());
                break;
            }
            case BYTES: {
                this.gen.writeBinary(reader.getBytes());
                break;
            }
            case DATE: {
                this.gen.writeDate(reader.getDate());
                break;
            }
            case DECIMAL: {
                this.gen.writeDecimal(reader.getDecimal());
                break;
            }
            case FLOAT: {
                this.gen.writeDouble(reader.getFloat());
                break;
            }
            case DOUBLE: {
                this.gen.writeDouble(reader.getDouble());
                break;
            }
            case INTEGER: {
                this.gen.writeInt(reader.getInt());
                break;
            }
            case LONG: {
                this.gen.writeBigInt(reader.getLong());
                break;
            }
            case NULL: {
                this.gen.writeUntypedNull();
                break;
            }
            case PERIOD: {
                this.gen.writeInterval(reader.getPeriod());
                break;
            }
            case STRING: {
                this.gen.writeVarChar(reader.getString());
                break;
            }
            case TIME: {
                this.gen.writeTime(reader.getTime());
                break;
            }
            case TIMESTAMP: {
                this.gen.writeTimestamp(reader.getTimestamp());
                break;
            }
            default: {
                throw new IllegalStateException(reader.valueType().name());
            }
        }
    }
}

