/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.project;

import java.util.List;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.exec.physical.resultSet.project.ImpliedTupleRequest;
import org.apache.drill.exec.physical.resultSet.project.ProjectionChecker;
import org.apache.drill.exec.physical.resultSet.project.Projections;
import org.apache.drill.exec.physical.resultSet.project.RequestedColumn;
import org.apache.drill.exec.physical.resultSet.project.RequestedColumnImpl;
import org.apache.drill.exec.physical.resultSet.project.RequestedTuple;
import org.apache.drill.exec.physical.resultSet.project.RequestedWildcardColumn;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleNameSpace;

public class RequestedTupleImpl
implements RequestedTuple {
    private final RequestedColumnImpl parent;
    protected RequestedTuple.TupleProjectionType projectionType = RequestedTuple.TupleProjectionType.SOME;
    private final TupleNameSpace<RequestedColumn> projection = new TupleNameSpace();

    public RequestedTupleImpl() {
        this.parent = null;
    }

    public RequestedTupleImpl(RequestedColumnImpl parent) {
        this.parent = parent;
    }

    public RequestedTupleImpl(List<RequestedColumn> cols) {
        this.parent = null;
        for (RequestedColumn col : cols) {
            this.projection.add(col.name(), col);
        }
    }

    @Override
    public int size() {
        return this.projection.count();
    }

    @Override
    public RequestedColumn get(int i) {
        return this.projection.get(i);
    }

    @Override
    public RequestedColumn get(String colName) {
        return this.projection.get(colName.toLowerCase());
    }

    protected RequestedColumnImpl getImpl(String colName) {
        return (RequestedColumnImpl)this.get(colName);
    }

    protected RequestedColumn project(String colName) {
        RequestedColumn col = this.get(colName);
        if (col != null) {
            if (col instanceof RequestedColumnImpl) {
                ((RequestedColumnImpl)col).bumpRefCount();
            }
        } else {
            if (colName.equals("**")) {
                this.projectionType = RequestedTuple.TupleProjectionType.ALL;
                col = new RequestedWildcardColumn(this, colName);
            } else {
                col = new RequestedColumnImpl(this, colName);
            }
            this.projection.add(colName, col);
        }
        return col;
    }

    @Override
    public List<RequestedColumn> projections() {
        return this.projection.entries();
    }

    @Override
    public void buildName(StringBuilder buf) {
        if (this.parent != null) {
            this.parent.buildName(buf);
        }
    }

    @Override
    public RequestedTuple.TupleProjectionType type() {
        return this.projectionType;
    }

    @Override
    public boolean isProjected(String colName) {
        return this.projectionType == RequestedTuple.TupleProjectionType.ALL ? true : this.get(colName) != null;
    }

    @Override
    public boolean isProjected(ColumnMetadata columnSchema) {
        if (!this.isProjected(columnSchema.name())) {
            return false;
        }
        return this.projectionType == RequestedTuple.TupleProjectionType.ALL ? !Projections.excludeFromWildcard(columnSchema) : true;
    }

    @Override
    public boolean enforceProjection(ColumnMetadata columnSchema, CustomErrorContext errorContext) {
        if (this.projectionType == RequestedTuple.TupleProjectionType.ALL) {
            return true;
        }
        RequestedColumn reqCol = this.get(columnSchema.name());
        if (reqCol == null) {
            return false;
        }
        ProjectionChecker.validateProjection(reqCol, columnSchema, errorContext);
        return true;
    }

    @Override
    public RequestedTuple mapProjection(String colName) {
        switch (this.projectionType) {
            case ALL: {
                return ImpliedTupleRequest.ALL_MEMBERS;
            }
            case NONE: {
                return ImpliedTupleRequest.NO_MEMBERS;
            }
        }
        RequestedColumnImpl colProj = this.getImpl(colName);
        return colProj == null ? ImpliedTupleRequest.NO_MEMBERS : colProj.tuple();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append("{");
        boolean first = true;
        for (RequestedColumn col : this.projections()) {
            if (!first) {
                buf.append(", ");
            }
            first = false;
            buf.append(col.toString());
        }
        return buf.append("}").toString();
    }

    @Override
    public boolean isEmpty() {
        return this.projections().isEmpty();
    }
}

