/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.project;

import org.apache.drill.exec.physical.resultSet.project.BaseRequestedColumn;
import org.apache.drill.exec.physical.resultSet.project.ImpliedTupleRequest;
import org.apache.drill.exec.physical.resultSet.project.Qualifier;
import org.apache.drill.exec.physical.resultSet.project.QualifierContainer;
import org.apache.drill.exec.physical.resultSet.project.RequestedTuple;

public class RequestedColumnImpl
extends BaseRequestedColumn
implements QualifierContainer {
    private int refCount = 1;
    private Qualifier qualifier;

    public RequestedColumnImpl(RequestedTuple parent, String name) {
        super(parent, name);
    }

    protected void bumpRefCount() {
        ++this.refCount;
    }

    public int refCount() {
        return this.refCount;
    }

    @Override
    public Qualifier qualifier() {
        return this.qualifier;
    }

    @Override
    public Qualifier requireQualifier() {
        if (this.qualifier == null) {
            this.qualifier = new Qualifier();
        }
        return this.qualifier;
    }

    @Override
    public boolean isWildcard() {
        return false;
    }

    @Override
    public boolean isSimple() {
        return this.qualifier == null;
    }

    @Override
    public boolean isTuple() {
        return this.qualifier != null && this.qualifier.isTuple();
    }

    @Override
    public RequestedTuple tuple() {
        if (!this.isTuple()) {
            return ImpliedTupleRequest.ALL_MEMBERS;
        }
        return this.qualifier.tuple();
    }

    @Override
    public boolean isArray() {
        return this.qualifier != null && this.qualifier.isArray();
    }

    @Override
    public boolean hasIndexes() {
        return this.qualifier != null && this.qualifier.hasIndexes();
    }

    @Override
    public boolean hasIndex(int index) {
        return this.qualifier != null && this.qualifier.hasIndex(index);
    }

    @Override
    public int maxIndex() {
        return this.qualifier == null ? 0 : this.qualifier.maxIndex();
    }

    @Override
    public boolean[] indexes() {
        return this.qualifier == null ? null : this.qualifier.indexArray();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append(this.name());
        if (this.qualifier != null) {
            buf.append(this.qualifier.toString());
        }
        return buf.toString();
    }

    @Override
    public int arrayDims() {
        return this.qualifier == null ? 0 : this.qualifier.arrayDims();
    }
}

