/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.project;

import java.util.Collection;
import java.util.List;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.resultSet.project.ImpliedTupleRequest;
import org.apache.drill.exec.physical.resultSet.project.Qualifier;
import org.apache.drill.exec.physical.resultSet.project.QualifierContainer;
import org.apache.drill.exec.physical.resultSet.project.RequestedColumn;
import org.apache.drill.exec.physical.resultSet.project.RequestedColumnImpl;
import org.apache.drill.exec.physical.resultSet.project.RequestedTuple;
import org.apache.drill.exec.physical.resultSet.project.RequestedTupleImpl;
import org.apache.drill.exec.record.metadata.ColumnMetadata;

public class Projections {
    private Projections() {
    }

    public static RequestedTuple projectAll() {
        return ImpliedTupleRequest.ALL_MEMBERS;
    }

    public static RequestedTuple projectNone() {
        return ImpliedTupleRequest.NO_MEMBERS;
    }

    public static RequestedTuple parse(Collection<SchemaPath> projList) {
        if (projList == null) {
            return Projections.projectAll();
        }
        if (projList.isEmpty()) {
            return Projections.projectNone();
        }
        RequestedTupleImpl tupleProj = new RequestedTupleImpl();
        for (SchemaPath col : projList) {
            Projections.parseMember(tupleProj, col.getRootSegment());
        }
        return tupleProj;
    }

    private static void parseMember(RequestedTupleImpl tuple, PathSegment.NameSegment nameSeg) {
        RequestedColumn col = tuple.project(nameSeg.getPath());
        if (!col.isWildcard()) {
            RequestedColumnImpl colImpl = (RequestedColumnImpl)col;
            Projections.parseChildSeg(colImpl, colImpl, nameSeg);
        }
    }

    private static void parseChildSeg(RequestedColumnImpl column, QualifierContainer parent, PathSegment parentPath) {
        if (parentPath.isLastPath()) {
            Projections.parseLeaf(parent);
        } else {
            PathSegment seg = parentPath.getChild();
            if (seg.isArray()) {
                Projections.parseArraySeg(column, parent, (PathSegment.ArraySegment)seg);
            } else {
                Projections.parseMemberSeg(column, parent, (PathSegment.NameSegment)seg);
            }
        }
    }

    private static void parseLeaf(QualifierContainer parent) {
        Qualifier qual = parent.qualifier();
        if (qual != null) {
            if (qual.isArray()) {
                qual.projectAllElements();
            } else if (qual.isTuple()) {
                qual.projectAllMembers();
            }
        }
    }

    private static void parseArraySeg(RequestedColumnImpl column, QualifierContainer parent, PathSegment.ArraySegment arraySeg) {
        Qualifier prevQualifier = parent.qualifier();
        Qualifier qualifier = parent.requireQualifier();
        if (!(column.refCount() <= 1 || prevQualifier != null && prevQualifier.isArray())) {
            qualifier.projectAllElements();
        } else {
            qualifier.addIndex(arraySeg.getIndex());
        }
        Projections.parseChildSeg(column, qualifier, arraySeg);
    }

    private static void parseMemberSeg(RequestedColumnImpl column, QualifierContainer parent, PathSegment.NameSegment memberSeg) {
        Qualifier prevQualifier = parent.qualifier();
        Qualifier qualifier = parent.requireQualifier();
        if (!(column.refCount() <= 1 || prevQualifier != null && prevQualifier.isTuple())) {
            qualifier.projectAllMembers();
        } else {
            RequestedTupleImpl tuple = qualifier.explicitMembers();
            if (tuple != null) {
                Projections.parseMember(tuple, memberSeg);
            }
        }
    }

    public static RequestedTuple build(List<RequestedColumn> projList) {
        if (projList == null) {
            return new ImpliedTupleRequest(true);
        }
        if (projList.isEmpty()) {
            return Projections.projectAll();
        }
        return new RequestedTupleImpl(projList);
    }

    public static boolean excludeFromWildcard(ColumnMetadata col) {
        return col.booleanProperty("drill.special");
    }
}

