/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.project;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.exec.physical.resultSet.project.Projections;
import org.apache.drill.exec.physical.resultSet.project.RequestedColumn;
import org.apache.drill.exec.physical.resultSet.project.RequestedTuple;
import org.apache.drill.exec.record.metadata.ColumnMetadata;

public class ImpliedTupleRequest
implements RequestedTuple {
    public static final RequestedTuple ALL_MEMBERS = new ImpliedTupleRequest(true);
    public static final RequestedTuple NO_MEMBERS = new ImpliedTupleRequest(false);
    public static final List<RequestedColumn> EMPTY_COLS = new ArrayList<RequestedColumn>();
    private final boolean allProjected;

    public ImpliedTupleRequest(boolean allProjected) {
        this.allProjected = allProjected;
    }

    @Override
    public RequestedTuple mapProjection(String colName) {
        return this.allProjected ? ALL_MEMBERS : NO_MEMBERS;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public RequestedColumn get(int i) {
        return null;
    }

    @Override
    public RequestedColumn get(String colName) {
        return null;
    }

    @Override
    public List<RequestedColumn> projections() {
        return EMPTY_COLS;
    }

    @Override
    public void buildName(StringBuilder buf) {
    }

    @Override
    public RequestedTuple.TupleProjectionType type() {
        return this.allProjected ? RequestedTuple.TupleProjectionType.ALL : RequestedTuple.TupleProjectionType.NONE;
    }

    @Override
    public boolean isProjected(String colName) {
        return this.allProjected;
    }

    @Override
    public boolean isProjected(ColumnMetadata columnSchema) {
        return this.allProjected ? !Projections.excludeFromWildcard(columnSchema) : false;
    }

    @Override
    public boolean enforceProjection(ColumnMetadata columnSchema, CustomErrorContext errorContext) {
        return this.isProjected(columnSchema);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append("{");
        if (this.allProjected) {
            buf.append("*");
        }
        return buf.append("}").toString();
    }

    @Override
    public boolean isEmpty() {
        return !this.allProjected;
    }
}

