/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.project;

import org.apache.drill.exec.physical.resultSet.project.RequestedColumn;
import org.apache.drill.exec.physical.resultSet.project.RequestedTuple;

public abstract class BaseRequestedColumn
implements RequestedColumn {
    private final RequestedTuple parent;
    private final String name;

    public BaseRequestedColumn(RequestedTuple parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String fullName() {
        StringBuilder buf = new StringBuilder();
        this.buildName(buf);
        return buf.toString();
    }

    protected void buildName(StringBuilder buf) {
        this.parent.buildName(buf);
        buf.append('`').append(this.name).append('`');
    }

    @Override
    public boolean nameEquals(String target) {
        return this.name.equalsIgnoreCase(target);
    }
}

