/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.model.single;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.protocol.BatchAccessor;
import org.apache.drill.exec.physical.resultSet.model.MetadataProvider;
import org.apache.drill.exec.physical.resultSet.model.ReaderBuilder;
import org.apache.drill.exec.physical.resultSet.model.ReaderIndex;
import org.apache.drill.exec.physical.resultSet.model.single.DirectRowIndex;
import org.apache.drill.exec.physical.rowSet.IndirectRowIndex;
import org.apache.drill.exec.physical.rowSet.RowSetReaderImpl;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.reader.AbstractObjectReader;
import org.apache.drill.exec.vector.accessor.reader.AbstractScalarReader;
import org.apache.drill.exec.vector.accessor.reader.ArrayReaderImpl;
import org.apache.drill.exec.vector.accessor.reader.DictReaderImpl;
import org.apache.drill.exec.vector.accessor.reader.MapReader;
import org.apache.drill.exec.vector.accessor.reader.UnionReaderImpl;
import org.apache.drill.exec.vector.accessor.reader.VectorAccessor;
import org.apache.drill.exec.vector.accessor.reader.VectorAccessors;
import org.apache.drill.exec.vector.complex.AbstractMapVector;
import org.apache.drill.exec.vector.complex.DictVector;
import org.apache.drill.exec.vector.complex.ListVector;
import org.apache.drill.exec.vector.complex.RepeatedListVector;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;
import org.apache.drill.exec.vector.complex.UnionVector;

public class SimpleReaderBuilder
extends ReaderBuilder {
    private static final SimpleReaderBuilder INSTANCE = new SimpleReaderBuilder();

    private SimpleReaderBuilder() {
    }

    public static RowSetReaderImpl build(VectorContainer container, TupleMetadata schema, ReaderIndex rowIndex) {
        return new RowSetReaderImpl(schema, rowIndex, INSTANCE.buildContainerChildren(container, new MetadataProvider.MetadataRetrieval(schema)));
    }

    public static RowSetReaderImpl build(VectorContainer container, ReaderIndex rowIndex) {
        MetadataProvider.MetadataCreator mdCreator = new MetadataProvider.MetadataCreator();
        List<AbstractObjectReader> children = INSTANCE.buildContainerChildren(container, mdCreator);
        return new RowSetReaderImpl(mdCreator.tuple(), rowIndex, children);
    }

    public static RowSetReaderImpl build(BatchAccessor batch) {
        return SimpleReaderBuilder.build(batch.container(), SimpleReaderBuilder.readerIndex(batch));
    }

    public static ReaderIndex readerIndex(BatchAccessor batch) {
        switch (batch.schema().getSelectionVectorMode()) {
            case TWO_BYTE: {
                return new IndirectRowIndex(batch.selectionVector2());
            }
            case NONE: {
                return new DirectRowIndex(batch.container());
            }
        }
        throw new UnsupportedOperationException("Cannot use this method for a hyper-batch");
    }

    public List<AbstractObjectReader> buildContainerChildren(VectorContainer container, MetadataProvider mdProvider) {
        ArrayList<AbstractObjectReader> readers = new ArrayList<AbstractObjectReader>();
        for (int i = 0; i < container.getNumberOfColumns(); ++i) {
            Object vector = container.getValueVector(i).getValueVector();
            MetadataProvider.VectorDescrip descrip = new MetadataProvider.VectorDescrip(mdProvider, i, vector.getField());
            readers.add(this.buildVectorReader((ValueVector)vector, descrip));
        }
        return readers;
    }

    protected AbstractObjectReader buildVectorReader(ValueVector vector, MetadataProvider.VectorDescrip descrip) {
        VectorAccessors.SingleVectorAccessor va = new VectorAccessors.SingleVectorAccessor(vector);
        TypeProtos.MajorType type = va.type();
        switch (type.getMinorType()) {
            case DICT: {
                return this.buildDict(vector, va, descrip);
            }
            case MAP: {
                return this.buildMap((AbstractMapVector)vector, va, type.getMode(), descrip);
            }
            case UNION: {
                return this.buildUnion((UnionVector)vector, va, descrip);
            }
            case LIST: {
                return this.buildList(vector, va, descrip);
            }
            case LATE: {
                return AbstractScalarReader.nullReader(descrip.metadata);
            }
        }
        return this.buildScalarReader(va, descrip.metadata);
    }

    private AbstractObjectReader buildDict(ValueVector vector, VectorAccessor va, MetadataProvider.VectorDescrip descrip) {
        VectorAccessor dictAccessor;
        DictVector dictVector;
        boolean isArray = descrip.metadata.isArray();
        if (isArray) {
            dictVector = (DictVector)((RepeatedValueVector)vector).getDataVector();
            dictAccessor = new VectorAccessors.SingleVectorAccessor(dictVector);
        } else {
            dictVector = (DictVector)vector;
            dictAccessor = va;
        }
        List<AbstractObjectReader> readers = this.buildMapMembers(dictVector, descrip.childProvider());
        DictReaderImpl.DictObjectReader reader = DictReaderImpl.build(descrip.metadata, dictAccessor, readers);
        if (!isArray) {
            return reader;
        }
        return ArrayReaderImpl.buildTuple(descrip.metadata, va, reader);
    }

    private AbstractObjectReader buildMap(AbstractMapVector vector, VectorAccessor va, TypeProtos.DataMode mode, MetadataProvider.VectorDescrip descrip) {
        boolean isArray = mode == TypeProtos.DataMode.REPEATED;
        AbstractObjectReader mapReader = MapReader.build(descrip.metadata, isArray ? null : va, this.buildMapMembers(vector, descrip.parent.childProvider(descrip.metadata)));
        if (isArray) {
            return ArrayReaderImpl.buildTuple(descrip.metadata, va, mapReader);
        }
        return mapReader;
    }

    protected List<AbstractObjectReader> buildMapMembers(AbstractMapVector mapVector, MetadataProvider provider) {
        ArrayList<AbstractObjectReader> readers = new ArrayList<AbstractObjectReader>();
        int i = 0;
        for (ValueVector vector : mapVector) {
            MetadataProvider.VectorDescrip descrip = new MetadataProvider.VectorDescrip(provider, i, vector.getField());
            readers.add(this.buildVectorReader(vector, descrip));
            ++i;
        }
        return readers;
    }

    private AbstractObjectReader buildUnion(UnionVector vector, VectorAccessor unionAccessor, MetadataProvider.VectorDescrip descrip) {
        MetadataProvider provider = descrip.childProvider();
        AbstractObjectReader[] variants = new AbstractObjectReader[TypeProtos.MinorType.values().length];
        int i = 0;
        for (TypeProtos.MinorType type : vector.getField().getType().getSubTypeList()) {
            ValueVector memberVector = vector.getMember(type);
            MetadataProvider.VectorDescrip memberDescrip = new MetadataProvider.VectorDescrip(provider, i++, memberVector.getField());
            variants[type.ordinal()] = this.buildVectorReader(memberVector, memberDescrip);
        }
        return UnionReaderImpl.build(descrip.metadata, unionAccessor, variants);
    }

    private AbstractObjectReader buildList(ValueVector vector, VectorAccessor listAccessor, MetadataProvider.VectorDescrip listDescrip) {
        if (vector.getField().getType().getMode() == TypeProtos.DataMode.REPEATED) {
            return this.buildMultiDList((RepeatedListVector)vector, listAccessor, listDescrip);
        }
        return this.build1DList((ListVector)vector, listAccessor, listDescrip);
    }

    private AbstractObjectReader buildMultiDList(RepeatedListVector vector, VectorAccessor listAccessor, MetadataProvider.VectorDescrip listDescrip) {
        ValueVector child = vector.getDataVector();
        if (child == null) {
            throw new UnsupportedOperationException("No child vector for repeated list.");
        }
        MetadataProvider.VectorDescrip childDescrip = new MetadataProvider.VectorDescrip(listDescrip.childProvider(), 0, child.getField());
        AbstractObjectReader elementReader = this.buildVectorReader(child, childDescrip);
        return ArrayReaderImpl.buildRepeatedList(listDescrip.metadata, listAccessor, elementReader);
    }

    private AbstractObjectReader build1DList(ListVector vector, VectorAccessor listAccessor, MetadataProvider.VectorDescrip listDescrip) {
        ValueVector dataVector = vector.getDataVector();
        MetadataProvider.VectorDescrip dataMetadata = dataVector.getField().getType().getMinorType() == TypeProtos.MinorType.UNION ? listDescrip : new MetadataProvider.VectorDescrip(listDescrip.childProvider(), 0, dataVector.getField());
        return ArrayReaderImpl.buildList(listDescrip.metadata, listAccessor, this.buildVectorReader(dataVector, dataMetadata));
    }
}

