/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.model.single;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.VariantMetadata;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractMapVector;
import org.apache.drill.exec.vector.complex.DictVector;
import org.apache.drill.exec.vector.complex.ListVector;
import org.apache.drill.exec.vector.complex.RepeatedDictVector;
import org.apache.drill.exec.vector.complex.RepeatedListVector;
import org.apache.drill.exec.vector.complex.UnionVector;

public class BuildVectorsFromMetadata {
    private final BufferAllocator allocator;

    public BuildVectorsFromMetadata(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    public VectorContainer build(TupleMetadata schema) {
        VectorContainer container = new VectorContainer(this.allocator);
        for (int i = 0; i < schema.size(); ++i) {
            container.add(this.buildVector(schema.metadata(i)));
        }
        container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        return container;
    }

    private ValueVector buildVector(ColumnMetadata metadata) {
        switch (metadata.structureType()) {
            case DICT: {
                return this.buildDict(metadata);
            }
            case TUPLE: {
                return this.buildMap(metadata);
            }
            case VARIANT: {
                if (metadata.isArray()) {
                    return this.builList(metadata);
                }
                return this.buildUnion(metadata);
            }
            case MULTI_ARRAY: {
                return this.buildRepeatedList(metadata);
            }
        }
        return TypeHelper.getNewVector(metadata.schema(), this.allocator, null);
    }

    private ValueVector buildRepeatedList(ColumnMetadata metadata) {
        RepeatedListVector listVector = new RepeatedListVector(metadata.emptySchema(), this.allocator, null);
        if (metadata.childSchema() != null) {
            ValueVector child = this.buildVector(metadata.childSchema());
            listVector.setChildVector(child);
        }
        return listVector;
    }

    private AbstractMapVector buildMap(ColumnMetadata schema) {
        AbstractMapVector mapVector = (AbstractMapVector)TypeHelper.getNewVector(schema.emptySchema(), this.allocator, null);
        this.populateMap(mapVector, schema.tupleSchema(), false);
        return mapVector;
    }

    private void populateMap(AbstractMapVector mapVector, TupleMetadata mapSchema, boolean inUnion) {
        for (int i = 0; i < mapSchema.size(); ++i) {
            ColumnMetadata childSchema = mapSchema.metadata(i);
            if (inUnion && !childSchema.isMap() && childSchema.mode() == TypeProtos.DataMode.REQUIRED) {
                throw new IllegalArgumentException("Map members in a list or union must not be non-nullable");
            }
            mapVector.putChild(childSchema.name(), this.buildVector(childSchema));
        }
    }

    private ValueVector buildUnion(ColumnMetadata metadata) {
        ValueVector vector = TypeHelper.getNewVector(metadata.emptySchema(), this.allocator, null);
        this.populateUnion((UnionVector)vector, metadata.variantSchema());
        return vector;
    }

    private void populateUnion(UnionVector unionVector, VariantMetadata variantSchema) {
        for (TypeProtos.MinorType type : variantSchema.types()) {
            ValueVector childVector = unionVector.getMember(type);
            switch (type) {
                case LIST: {
                    this.populateList((ListVector)childVector, variantSchema.member(TypeProtos.MinorType.LIST).variantSchema());
                    break;
                }
                case MAP: {
                    this.populateMap((AbstractMapVector)childVector, variantSchema.member(TypeProtos.MinorType.MAP).tupleSchema(), true);
                    break;
                }
            }
        }
    }

    private ValueVector builList(ColumnMetadata metadata) {
        ValueVector vector = TypeHelper.getNewVector(metadata.emptySchema(), this.allocator, null);
        this.populateList((ListVector)vector, metadata.variantSchema());
        return vector;
    }

    private void populateList(ListVector vector, VariantMetadata variantSchema) {
        if (variantSchema.size() == 0) {
            return;
        }
        if (variantSchema.size() == 1) {
            ColumnMetadata subtype = variantSchema.listSubtype();
            ValueVector childVector = this.buildVector(subtype);
            vector.setChildVector(childVector);
        } else {
            this.populateUnion(vector.fullPromoteToUnion(), variantSchema);
        }
    }

    private ValueVector buildDict(ColumnMetadata metadata) {
        if (metadata.isArray()) {
            return this.buildRepeatedDict(metadata);
        }
        return this.buildMap(metadata);
    }

    private RepeatedDictVector buildRepeatedDict(ColumnMetadata schema) {
        RepeatedDictVector repeatedDictVector = (RepeatedDictVector)TypeHelper.getNewVector(schema.emptySchema(), this.allocator, null);
        this.populateDict(repeatedDictVector, schema.tupleSchema());
        return repeatedDictVector;
    }

    private void populateDict(RepeatedDictVector vector, TupleMetadata dictMetadata) {
        for (int i = 0; i < dictMetadata.size(); ++i) {
            ColumnMetadata childSchema = dictMetadata.metadata(i);
            DictVector dataVector = (DictVector)vector.getDataVector();
            dataVector.putChild(childSchema.name(), this.buildVector(childSchema));
        }
    }
}

