/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.model.hyper;

import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.record.metadata.VariantMetadata;
import org.apache.drill.exec.vector.ValueVector;

public class HyperSchemaInference {
    public TupleMetadata infer(VectorContainer container) throws SchemaChangeException {
        TupleSchema schema = new TupleSchema();
        for (int i = 0; i < container.getNumberOfColumns(); ++i) {
            VectorWrapper<?> vw = container.getValueVector(i);
            schema.addColumn(this.buildColumn(vw));
        }
        return schema;
    }

    private ColumnMetadata buildColumn(VectorWrapper<?> vw) throws SchemaChangeException {
        VariantMetadata variantSchema;
        ColumnMetadata commonSchema = null;
        for (ValueVector vector : vw.getValueVectors()) {
            ColumnMetadata mapSchema = MetadataUtils.fromField(vector.getField());
            if (commonSchema == null) {
                commonSchema = mapSchema;
                continue;
            }
            if (commonSchema.isEquivalent(mapSchema)) continue;
            throw new SchemaChangeException("Maps are not consistent");
        }
        if (commonSchema.isVariant() && (variantSchema = commonSchema.variantSchema()).size() == 1) {
            variantSchema.becomeSimple();
        }
        return commonSchema;
    }
}

