/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.model.hyper;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.physical.impl.protocol.BatchAccessor;
import org.apache.drill.exec.physical.resultSet.model.ReaderBuilder;
import org.apache.drill.exec.physical.resultSet.model.ReaderIndex;
import org.apache.drill.exec.physical.resultSet.model.hyper.HyperSchemaInference;
import org.apache.drill.exec.physical.rowSet.HyperRowIndex;
import org.apache.drill.exec.physical.rowSet.RowSetReaderImpl;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.VariantMetadata;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.ColumnReaderIndex;
import org.apache.drill.exec.vector.accessor.reader.AbstractObjectReader;
import org.apache.drill.exec.vector.accessor.reader.ArrayReaderImpl;
import org.apache.drill.exec.vector.accessor.reader.DictReaderImpl;
import org.apache.drill.exec.vector.accessor.reader.MapReader;
import org.apache.drill.exec.vector.accessor.reader.UnionReaderImpl;
import org.apache.drill.exec.vector.accessor.reader.VectorAccessor;
import org.apache.drill.exec.vector.accessor.reader.VectorAccessors;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;

public class HyperReaderBuilder
extends ReaderBuilder {
    private static final HyperReaderBuilder INSTANCE = new HyperReaderBuilder();

    private HyperReaderBuilder() {
    }

    public static RowSetReaderImpl build(VectorContainer container, TupleMetadata schema, SelectionVector4 sv4) {
        HyperRowIndex rowIndex = new HyperRowIndex(sv4);
        return new RowSetReaderImpl(schema, (ReaderIndex)rowIndex, INSTANCE.buildContainerChildren(container, schema));
    }

    public static RowSetReaderImpl build(BatchAccessor batch) throws SchemaChangeException {
        VectorContainer container = batch.container();
        return HyperReaderBuilder.build(container, new HyperSchemaInference().infer(container), batch.selectionVector4());
    }

    protected List<AbstractObjectReader> buildContainerChildren(VectorContainer container) throws SchemaChangeException {
        TupleMetadata schema = new HyperSchemaInference().infer(container);
        return this.buildContainerChildren(container, schema);
    }

    protected List<AbstractObjectReader> buildContainerChildren(VectorContainer container, TupleMetadata schema) {
        ArrayList<AbstractObjectReader> readers = new ArrayList<AbstractObjectReader>();
        for (int i = 0; i < container.getNumberOfColumns(); ++i) {
            VectorWrapper<?> vw = container.getValueVector(i);
            HyperVectorAccessor va = new HyperVectorAccessor(vw);
            readers.add(this.buildVectorReader(va, schema.metadata(i)));
        }
        return readers;
    }

    protected AbstractObjectReader buildVectorReader(VectorAccessor va, ColumnMetadata metadata) {
        switch (metadata.type()) {
            case DICT: {
                return this.buildDict(va, metadata);
            }
            case MAP: {
                return this.buildMap(va, metadata.mode(), metadata);
            }
            case UNION: {
                return this.buildUnion(va, metadata);
            }
            case LIST: {
                return this.buildList(va, metadata);
            }
        }
        return this.buildScalarReader(va, metadata);
    }

    private AbstractObjectReader buildDict(VectorAccessor va, ColumnMetadata metadata) {
        VectorAccessor dictAccessor;
        boolean isArray = metadata.isArray();
        Object vector = va.vector();
        if (isArray) {
            ValueVector dictVector = ((RepeatedValueVector)vector).getDataVector();
            dictAccessor = new VectorAccessors.SingleVectorAccessor(dictVector);
        } else {
            dictAccessor = va;
        }
        List<AbstractObjectReader> readers = this.buildMapMembers(dictAccessor, metadata.tupleSchema());
        DictReaderImpl.DictObjectReader reader = DictReaderImpl.build(metadata, dictAccessor, readers);
        if (!isArray) {
            return reader;
        }
        return ArrayReaderImpl.buildTuple(metadata, va, reader);
    }

    private AbstractObjectReader buildMap(VectorAccessor va, TypeProtos.DataMode mode, ColumnMetadata metadata) {
        boolean isArray = mode == TypeProtos.DataMode.REPEATED;
        AbstractObjectReader mapReader = MapReader.build(metadata, isArray ? null : va, this.buildMapMembers(va, metadata.tupleSchema()));
        if (!isArray) {
            return mapReader;
        }
        return ArrayReaderImpl.buildTuple(metadata, va, mapReader);
    }

    protected List<AbstractObjectReader> buildMapMembers(VectorAccessor va, TupleMetadata mapSchema) {
        ArrayList<AbstractObjectReader> readers = new ArrayList<AbstractObjectReader>();
        for (int i = 0; i < mapSchema.size(); ++i) {
            ColumnMetadata member = mapSchema.metadata(i);
            readers.add(this.buildVectorReader(new VectorAccessors.MapMemberHyperVectorAccessor(va, i, member.majorType()), member));
        }
        return readers;
    }

    private AbstractObjectReader buildUnion(VectorAccessor unionAccessor, ColumnMetadata metadata) {
        VariantMetadata unionSchema = metadata.variantSchema();
        AbstractObjectReader[] variants = new AbstractObjectReader[TypeProtos.MinorType.values().length];
        for (ColumnMetadata member : unionSchema.members()) {
            variants[member.type().ordinal()] = this.buildVectorReader(new VectorAccessors.UnionMemberHyperVectorAccessor(unionAccessor, member.majorType()), member);
        }
        return UnionReaderImpl.build(metadata, unionAccessor, variants);
    }

    private AbstractObjectReader buildList(VectorAccessor listAccessor, ColumnMetadata metadata) {
        VariantMetadata listSchema = metadata.variantSchema();
        ColumnMetadata dataMetadata = listSchema.listSubtype();
        return ArrayReaderImpl.buildList(metadata, listAccessor, this.buildVectorReader(new VectorAccessors.ListMemberHyperVectorAccessor(listAccessor, dataMetadata.majorType()), dataMetadata));
    }

    public static class HyperVectorAccessor
    extends VectorAccessors.BaseHyperVectorAccessor {
        private final ValueVector[] vectors;
        private ColumnReaderIndex rowIndex;

        public HyperVectorAccessor(VectorWrapper<?> vw) {
            super(vw.getField().getType());
            this.vectors = vw.getValueVectors();
        }

        @Override
        public void bind(ColumnReaderIndex index) {
            this.rowIndex = index;
        }

        @Override
        public <T extends ValueVector> T vector() {
            return (T)this.vectors[this.rowIndex.hyperVectorIndex()];
        }
    }
}

