/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.model;

import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.RepeatedListColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.record.metadata.VariantMetadata;
import org.apache.drill.exec.record.metadata.VariantSchema;

public interface MetadataProvider {
    public ColumnMetadata metadata(int var1, MaterializedField var2);

    public MetadataProvider childProvider(ColumnMetadata var1);

    public TupleMetadata tuple();

    public VariantMetadata variant();

    public static class ArraySchemaRetrieval
    implements MetadataProvider {
        private final ColumnMetadata arraySchema;

        public ArraySchemaRetrieval(ColumnMetadata arraySchema) {
            this.arraySchema = arraySchema;
        }

        @Override
        public ColumnMetadata metadata(int index, MaterializedField field) {
            assert (index == 0);
            return this.arraySchema.childSchema();
        }

        @Override
        public MetadataProvider childProvider(ColumnMetadata colMetadata) {
            return MetadataRetrieval.makeProvider(colMetadata);
        }

        @Override
        public TupleMetadata tuple() {
            throw new UnsupportedOperationException();
        }

        @Override
        public VariantMetadata variant() {
            throw new UnsupportedOperationException();
        }
    }

    public static class VariantSchemaRetrieval
    implements MetadataProvider {
        private final VariantSchema variantSchema;

        public VariantSchemaRetrieval(VariantSchema variantSchema) {
            this.variantSchema = variantSchema;
        }

        @Override
        public ColumnMetadata metadata(int index, MaterializedField field) {
            return this.variantSchema.member(field.getType().getMinorType());
        }

        @Override
        public MetadataProvider childProvider(ColumnMetadata colMetadata) {
            return MetadataRetrieval.makeProvider(colMetadata);
        }

        @Override
        public TupleMetadata tuple() {
            throw new UnsupportedOperationException();
        }

        @Override
        public VariantMetadata variant() {
            return this.variantSchema;
        }
    }

    public static class MetadataRetrieval
    implements MetadataProvider {
        private final TupleMetadata tuple;

        public MetadataRetrieval(TupleMetadata schema) {
            this.tuple = schema;
        }

        @Override
        public ColumnMetadata metadata(int index, MaterializedField field) {
            return this.tuple.metadata(index);
        }

        @Override
        public MetadataProvider childProvider(ColumnMetadata colMetadata) {
            return MetadataRetrieval.makeProvider(colMetadata);
        }

        public static MetadataProvider makeProvider(ColumnMetadata colMetadata) {
            switch (colMetadata.structureType()) {
                case MULTI_ARRAY: {
                    return new ArraySchemaRetrieval(colMetadata);
                }
                case VARIANT: {
                    return new VariantSchemaRetrieval((VariantSchema)colMetadata.variantSchema());
                }
                case DICT: 
                case TUPLE: {
                    return new MetadataRetrieval(colMetadata.tupleSchema());
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public TupleMetadata tuple() {
            return this.tuple;
        }

        @Override
        public VariantMetadata variant() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ArraySchemaCreator
    implements MetadataProvider {
        private final RepeatedListColumnMetadata arraySchema;

        public ArraySchemaCreator(RepeatedListColumnMetadata arraySchema) {
            this.arraySchema = arraySchema;
        }

        @Override
        public ColumnMetadata metadata(int index, MaterializedField field) {
            assert (index == 0);
            assert (this.arraySchema.childSchema() == null);
            ColumnMetadata childSchema = MetadataUtils.fromField(field.cloneEmpty());
            this.arraySchema.childSchema(childSchema);
            return childSchema;
        }

        @Override
        public MetadataProvider childProvider(ColumnMetadata colMetadata) {
            return MetadataCreator.makeProvider(colMetadata);
        }

        @Override
        public TupleMetadata tuple() {
            throw new UnsupportedOperationException();
        }

        @Override
        public VariantMetadata variant() {
            throw new UnsupportedOperationException();
        }
    }

    public static class VariantSchemaCreator
    implements MetadataProvider {
        private final VariantSchema variantSchema;

        public VariantSchemaCreator(VariantSchema variantSchema) {
            this.variantSchema = variantSchema;
        }

        @Override
        public ColumnMetadata metadata(int index, MaterializedField field) {
            return this.variantSchema.addType(field);
        }

        @Override
        public MetadataProvider childProvider(ColumnMetadata colMetadata) {
            return MetadataCreator.makeProvider(colMetadata);
        }

        @Override
        public TupleMetadata tuple() {
            throw new UnsupportedOperationException();
        }

        @Override
        public VariantMetadata variant() {
            return this.variantSchema;
        }
    }

    public static class MetadataCreator
    implements MetadataProvider {
        private final TupleSchema tuple;

        public MetadataCreator() {
            this.tuple = new TupleSchema();
        }

        public MetadataCreator(TupleSchema tuple) {
            this.tuple = tuple;
        }

        @Override
        public ColumnMetadata metadata(int index, MaterializedField field) {
            return this.tuple.addView(field);
        }

        @Override
        public MetadataProvider childProvider(ColumnMetadata colMetadata) {
            return MetadataCreator.makeProvider(colMetadata);
        }

        public static MetadataProvider makeProvider(ColumnMetadata colMetadata) {
            switch (colMetadata.structureType()) {
                case MULTI_ARRAY: {
                    return new ArraySchemaCreator((RepeatedListColumnMetadata)colMetadata);
                }
                case VARIANT: {
                    return new VariantSchemaCreator((VariantSchema)colMetadata.variantSchema());
                }
                case DICT: 
                case TUPLE: {
                    return new MetadataCreator((TupleSchema)colMetadata.tupleSchema());
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public TupleMetadata tuple() {
            return this.tuple;
        }

        @Override
        public VariantMetadata variant() {
            throw new UnsupportedOperationException();
        }
    }

    public static class VectorDescrip {
        public final MetadataProvider parent;
        public final ColumnMetadata metadata;

        public VectorDescrip(MetadataProvider provider, ColumnMetadata metadata) {
            this.parent = provider;
            this.metadata = metadata;
        }

        public VectorDescrip(MetadataProvider provider, int index, MaterializedField field) {
            this(provider, provider.metadata(index, field));
        }

        public MetadataProvider childProvider() {
            return this.parent.childProvider(this.metadata);
        }
    }
}

