/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.physical.resultSet.model.TupleModel;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;

public abstract class BaseTupleModel
implements TupleModel {
    protected final List<TupleModel.ColumnModel> columns;
    protected final TupleMetadata schema;

    public BaseTupleModel() {
        this.schema = new TupleSchema();
        this.columns = new ArrayList<TupleModel.ColumnModel>();
    }

    public BaseTupleModel(TupleMetadata schema, List<TupleModel.ColumnModel> columns) {
        this.schema = schema;
        this.columns = columns;
        assert (schema.size() == columns.size());
    }

    @Override
    public TupleMetadata schema() {
        return this.schema;
    }

    @Override
    public int size() {
        return this.schema.size();
    }

    @Override
    public TupleModel.ColumnModel column(int index) {
        return this.columns.get(index);
    }

    @Override
    public TupleModel.ColumnModel column(String name) {
        return this.column(this.schema.index(name));
    }

    protected void addBaseColumn(BaseColumnModel column) {
        this.schema.addColumn(column.schema());
        this.columns.add(column);
        assert (this.columns.size() == this.schema.size());
    }

    public static abstract class BaseColumnModel
    implements TupleModel.ColumnModel {
        protected final ColumnMetadata schema;

        public BaseColumnModel(ColumnMetadata schema) {
            this.schema = schema;
        }

        @Override
        public ColumnMetadata schema() {
            return this.schema;
        }

        @Override
        public TupleModel mapModel() {
            return null;
        }
    }
}

