/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.vector.accessor.ColumnWriterIndex;

class WriterIndexImpl
implements ColumnWriterIndex {
    private final ResultSetLoader rsLoader;
    private int rowIndex;

    public WriterIndexImpl(ResultSetLoader rsLoader) {
        this.rsLoader = rsLoader;
    }

    @Override
    public int vectorIndex() {
        return this.rowIndex;
    }

    @Override
    public int rowStartIndex() {
        return this.rowIndex;
    }

    public boolean next() {
        if (++this.rowIndex < this.rsLoader.targetRowCount()) {
            return true;
        }
        this.rowIndex = this.rsLoader.targetRowCount();
        return false;
    }

    public int skipRows(int requestedCount) {
        int skipped = Math.min(requestedCount, 65536 - this.rowIndex);
        this.rowIndex += skipped;
        return skipped;
    }

    public int size() {
        return this.rowIndex;
    }

    public boolean valid() {
        return this.rowIndex < this.rsLoader.maxBatchSize();
    }

    @Override
    public void rollover() {
        this.reset();
    }

    public void reset() {
        this.rowIndex = 0;
    }

    @Override
    public void nextElement() {
    }

    @Override
    public void prevElement() {
    }

    @Override
    public ColumnWriterIndex outerIndex() {
        return null;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + " rowIndex = " + this.rowIndex + "]";
    }
}

