/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.resultSet.ResultVectorCache;
import org.apache.drill.exec.physical.resultSet.impl.ColumnState;
import org.apache.drill.exec.physical.resultSet.impl.ContainerState;
import org.apache.drill.exec.physical.resultSet.impl.LoaderInternals;
import org.apache.drill.exec.physical.resultSet.impl.NullVectorState;
import org.apache.drill.exec.physical.resultSet.impl.ProjectionFilter;
import org.apache.drill.exec.physical.resultSet.impl.SingleVectorState;
import org.apache.drill.exec.physical.resultSet.impl.VectorState;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.VariantMetadata;
import org.apache.drill.exec.record.metadata.VariantSchema;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.ObjectWriter;
import org.apache.drill.exec.vector.accessor.VariantWriter;
import org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import org.apache.drill.exec.vector.accessor.writer.UnionVectorShim;
import org.apache.drill.exec.vector.accessor.writer.UnionWriterImpl;
import org.apache.drill.exec.vector.complex.UnionVector;

public class UnionState
extends ContainerState
implements VariantWriter.VariantWriterListener {
    private final Map<TypeProtos.MinorType, ColumnState> columns = new HashMap<TypeProtos.MinorType, ColumnState>();

    public UnionState(LoaderInternals events, ResultVectorCache vectorCache, ProjectionFilter projectionSet) {
        super(events, vectorCache, projectionSet);
    }

    public UnionWriterImpl writer() {
        return (UnionWriterImpl)this.parentColumn.writer.variant();
    }

    public VariantMetadata variantSchema() {
        return this.writer().variantSchema();
    }

    public UnionVector vector() {
        return (UnionVector)this.parentColumn.vector();
    }

    @Override
    public ObjectWriter addType(TypeProtos.MinorType type) {
        return this.addMember(VariantSchema.memberMetadata(type));
    }

    @Override
    public ObjectWriter addMember(ColumnMetadata member) {
        if (this.variantSchema().hasType(member.type())) {
            throw new IllegalArgumentException("Duplicate type: " + member.type().toString());
        }
        return this.addColumn(member).writer();
    }

    @Override
    protected void addColumn(ColumnState colState) {
        assert (!this.columns.containsKey(colState.schema().type()));
        this.columns.put(colState.schema().type(), colState);
        if (this.vector() == null) {
            if (colState.vector() != null) {
                throw new IllegalStateException("Attempt to add a materialized vector to an unprojected vector");
            }
        } else {
            this.vector().addType((ValueVector)colState.vector());
        }
    }

    @Override
    protected Collection<ColumnState> columnStates() {
        return this.columns.values();
    }

    @Override
    public int innerCardinality() {
        return this.parentColumn.innerCardinality();
    }

    @Override
    protected boolean isVersioned() {
        return false;
    }

    public static class UnionVectorState
    implements VectorState {
        private final UnionVector vector;
        private final VectorState typesVectorState;

        public UnionVectorState(UnionVector vector, UnionWriterImpl unionWriter) {
            this.vector = vector;
            this.typesVectorState = vector == null ? new NullVectorState() : new SingleVectorState.FixedWidthVectorState(((UnionVectorShim)unionWriter.shim()).typeWriter(), vector.getTypeVector());
        }

        @Override
        public int allocate(int cardinality) {
            return this.typesVectorState.allocate(cardinality);
        }

        @Override
        public void rollover(int cardinality) {
            this.typesVectorState.rollover(cardinality);
        }

        @Override
        public void harvestWithLookAhead() {
            this.typesVectorState.harvestWithLookAhead();
        }

        @Override
        public void startBatchWithLookAhead() {
            this.typesVectorState.startBatchWithLookAhead();
        }

        @Override
        public void close() {
            this.typesVectorState.close();
        }

        public UnionVector vector() {
            return this.vector;
        }

        @Override
        public boolean isProjected() {
            return this.vector != null;
        }

        @Override
        public void dump(HierarchicalFormatter format) {
        }
    }

    public static class UnionColumnState
    extends ColumnState.BaseContainerColumnState {
        private final ContainerState unionState;

        public UnionColumnState(LoaderInternals loader, AbstractObjectWriter writer, VectorState vectorState, ContainerState unionState) {
            super(loader, writer, vectorState);
            this.unionState = unionState;
            unionState.bindColumnState(this);
        }

        @Override
        public boolean isProjected() {
            return true;
        }

        @Override
        public ColumnMetadata outputSchema() {
            return this.schema();
        }

        @Override
        public ContainerState container() {
            return this.unionState;
        }
    }
}

