/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.drill.exec.physical.resultSet.ResultVectorCache;
import org.apache.drill.exec.physical.resultSet.impl.BuildFromSchema;
import org.apache.drill.exec.physical.resultSet.impl.ColumnState;
import org.apache.drill.exec.physical.resultSet.impl.ContainerState;
import org.apache.drill.exec.physical.resultSet.impl.LoaderInternals;
import org.apache.drill.exec.physical.resultSet.impl.ProjectionFilter;
import org.apache.drill.exec.physical.resultSet.impl.ResultSetLoaderImpl;
import org.apache.drill.exec.physical.resultSet.impl.RowSetLoaderImpl;
import org.apache.drill.exec.physical.resultSet.impl.VectorState;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.ObjectWriter;
import org.apache.drill.exec.vector.accessor.TupleWriter;
import org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import org.apache.drill.exec.vector.accessor.writer.AbstractTupleWriter;
import org.apache.drill.exec.vector.complex.AbstractMapVector;
import org.apache.drill.exec.vector.complex.DictVector;
import org.apache.drill.exec.vector.complex.RepeatedDictVector;

public abstract class TupleState
extends ContainerState
implements AbstractTupleWriter.TupleWriterListener {
    protected final List<ColumnState> columns = new ArrayList<ColumnState>();
    protected final TupleMetadata schema = new TupleSchema();
    protected TupleMetadata outputSchema;
    private int prevHarvestIndex = -1;

    protected TupleState(LoaderInternals events, ResultVectorCache vectorCache, ProjectionFilter projectionSet) {
        super(events, vectorCache, projectionSet);
    }

    protected void bindOutputSchema(TupleMetadata outputSchema) {
        this.outputSchema = outputSchema;
    }

    public List<ColumnState> columns() {
        return this.columns;
    }

    public TupleMetadata schema() {
        return this.writer().tupleSchema();
    }

    public abstract AbstractTupleWriter writer();

    @Override
    public boolean isProjected(String colName) {
        return this.projectionSet.isProjected(colName);
    }

    @Override
    public ObjectWriter addColumn(TupleWriter tupleWriter, MaterializedField column) {
        return this.addColumn(tupleWriter, MetadataUtils.fromField(column));
    }

    @Override
    public ObjectWriter addColumn(TupleWriter tupleWriter, ColumnMetadata columnSchema) {
        return BuildFromSchema.instance().buildColumn(this, columnSchema);
    }

    @Override
    protected void addColumn(ColumnState colState) {
        this.columns.add(colState);
    }

    public boolean hasProjections() {
        for (ColumnState colState : this.columns) {
            if (!colState.isProjected()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Collection<ColumnState> columnStates() {
        return this.columns;
    }

    protected void updateOutput(int curSchemaVersion) {
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnState colState = this.columns.get(i);
            if (!colState.writer().isProjected()) continue;
            if (!(i <= this.prevHarvestIndex || this.isVersioned() && colState.addVersion > curSchemaVersion)) {
                colState.buildOutput(this);
                this.prevHarvestIndex = i;
            }
            if (colState.schema().isMap()) {
                MapState childMap = ((MapColumnState)colState).mapState();
                childMap.updateOutput(curSchemaVersion);
                continue;
            }
            if (!colState.schema().isDict()) continue;
            DictState child = ((DictColumnState)colState).dictState();
            child.updateOutput(curSchemaVersion);
        }
    }

    public abstract int addOutputColumn(ValueVector var1, ColumnMetadata var2);

    public TupleMetadata outputSchema() {
        return this.outputSchema;
    }

    public void dump(HierarchicalFormatter format) {
        format.startObject(this).attributeArray("columns");
        for (int i = 0; i < this.columns.size(); ++i) {
            format.element(i);
            this.columns.get(i).dump(format);
        }
        format.endArray().endObject();
    }

    public static class MapColumnState
    extends ColumnState.BaseContainerColumnState {
        protected final MapState mapState;
        protected boolean isVersioned;
        protected final ColumnMetadata outputSchema;

        public MapColumnState(MapState mapState, AbstractObjectWriter writer, VectorState vectorState, boolean isVersioned) {
            super(mapState.loader(), writer, vectorState);
            this.mapState = mapState;
            mapState.bindColumnState(this);
            this.isVersioned = isVersioned;
            this.outputSchema = isVersioned ? this.schema().cloneEmpty() : this.schema();
            mapState.bindOutputSchema(this.outputSchema.tupleSchema());
        }

        public MapState mapState() {
            return this.mapState;
        }

        @Override
        public ContainerState container() {
            return this.mapState;
        }

        @Override
        public boolean isProjected() {
            return this.mapState.hasProjections();
        }

        public boolean isVersioned() {
            return this.isVersioned;
        }

        @Override
        public ColumnMetadata outputSchema() {
            return this.outputSchema;
        }
    }

    public static abstract class MapState
    extends TupleState {
        public MapState(LoaderInternals events, ResultVectorCache vectorCache, ProjectionFilter projectionSet) {
            super(events, vectorCache, projectionSet);
        }

        public void bindColumnState(MapColumnState colState) {
            super.bindColumnState(colState);
            this.writer().bindListener(this);
        }

        @Override
        public int addOutputColumn(ValueVector vector, ColumnMetadata colSchema) {
            AbstractMapVector mapVector = (AbstractMapVector)this.parentColumn.vector();
            if (this.isVersioned()) {
                mapVector.putChild(colSchema.name(), vector);
            }
            int index = this.outputSchema.addColumn(colSchema);
            assert (mapVector.size() == this.outputSchema.size());
            assert (mapVector.getField().getChildren().size() == this.outputSchema.size());
            return index;
        }

        @Override
        protected void addColumn(ColumnState colState) {
            super.addColumn(colState);
            if (!this.isVersioned()) {
                AbstractMapVector mapVector = (AbstractMapVector)this.parentColumn.vector();
                mapVector.putChild(colState.schema().name(), (ValueVector)colState.vector());
            }
        }

        @Override
        protected boolean isVersioned() {
            return ((MapColumnState)this.parentColumn).isVersioned();
        }

        @Override
        public int innerCardinality() {
            return this.parentColumn.innerCardinality();
        }

        @Override
        public void dump(HierarchicalFormatter format) {
            format.startObject(this).attribute("column", this.parentColumn.schema().name()).attribute("cardinality", this.innerCardinality()).endObject();
        }
    }

    public static class DictColumnState
    extends ColumnState.BaseContainerColumnState {
        protected final DictState dictState;
        protected boolean isVersioned;
        protected final ColumnMetadata outputSchema;

        public DictColumnState(DictState dictState, AbstractObjectWriter writer, VectorState vectorState, boolean isVersioned) {
            super(dictState.loader(), writer, vectorState);
            this.dictState = dictState;
            dictState.bindColumnState(this);
            this.isVersioned = isVersioned;
            this.outputSchema = isVersioned ? this.schema().cloneEmpty() : this.schema();
            dictState.bindOutputSchema(this.outputSchema.tupleSchema());
        }

        @Override
        public void buildOutput(TupleState tupleState) {
            this.outputIndex = tupleState.addOutputColumn((ValueVector)this.vector(), this.outputSchema());
        }

        public DictState dictState() {
            return this.dictState;
        }

        @Override
        public ContainerState container() {
            return this.dictState;
        }

        @Override
        public boolean isProjected() {
            return this.dictState.hasProjections();
        }

        public boolean isVersioned() {
            return this.isVersioned;
        }

        @Override
        public ColumnMetadata outputSchema() {
            return this.outputSchema;
        }
    }

    public static abstract class DictState
    extends MapState {
        public DictState(LoaderInternals events, ResultVectorCache vectorCache, ProjectionFilter projectionSet) {
            super(events, vectorCache, projectionSet);
        }

        @Override
        public void bindColumnState(ColumnState colState) {
            super.bindColumnState(colState);
            this.writer().bindListener(this);
        }

        @Override
        protected boolean isVersioned() {
            return ((DictColumnState)this.parentColumn).isVersioned();
        }

        @Override
        public void dump(HierarchicalFormatter format) {
            format.startObject(this).attribute("column", this.parentColumn.schema().name()).attribute("cardinality", this.innerCardinality()).endObject();
        }
    }

    public static class DictArrayVectorState
    extends DictVectorState<RepeatedDictVector> {
        private final VectorState dictOffsets;

        public DictArrayVectorState(RepeatedDictVector vector, VectorState offsets, VectorState dictOffsets) {
            super(vector, offsets);
            this.dictOffsets = dictOffsets;
        }

        @Override
        public int allocate(int cardinality) {
            return this.offsets.allocate(cardinality);
        }

        @Override
        public void rollover(int cardinality) {
            super.rollover(cardinality);
            this.dictOffsets.rollover(cardinality);
        }

        @Override
        public void harvestWithLookAhead() {
            super.harvestWithLookAhead();
            this.dictOffsets.harvestWithLookAhead();
        }

        @Override
        public void startBatchWithLookAhead() {
            super.startBatchWithLookAhead();
            this.dictOffsets.harvestWithLookAhead();
        }

        @Override
        public void close() {
            super.close();
            this.dictOffsets.close();
        }
    }

    public static class SingleDictVectorState
    extends DictVectorState<DictVector> {
        public SingleDictVectorState(DictVector vector, VectorState offsets) {
            super(vector, offsets);
        }
    }

    public static abstract class DictVectorState<T extends ValueVector>
    implements VectorState {
        protected final T vector;
        protected final VectorState offsets;

        public DictVectorState(T vector, VectorState offsets) {
            this.vector = vector;
            this.offsets = offsets;
        }

        @Override
        public T vector() {
            return this.vector;
        }

        @Override
        public int allocate(int cardinality) {
            return this.offsets.allocate(cardinality);
        }

        @Override
        public void rollover(int cardinality) {
            this.offsets.rollover(cardinality);
        }

        @Override
        public void harvestWithLookAhead() {
            this.offsets.harvestWithLookAhead();
        }

        @Override
        public void startBatchWithLookAhead() {
            this.offsets.harvestWithLookAhead();
        }

        @Override
        public void close() {
            this.offsets.close();
        }

        public VectorState offsetVectorState() {
            return this.offsets;
        }

        @Override
        public boolean isProjected() {
            return this.offsets.isProjected();
        }

        @Override
        public void dump(HierarchicalFormatter format) {
            format.startObject(this).attribute("field", this.vector != null ? this.vector.getField() : "null").endObject();
        }
    }

    public static class DictArrayState
    extends DictState {
        public DictArrayState(LoaderInternals events, ResultVectorCache vectorCache, ProjectionFilter projectionSet) {
            super(events, vectorCache, projectionSet);
        }

        @Override
        public int addOutputColumn(ValueVector vector, ColumnMetadata colSchema) {
            RepeatedDictVector repeatedDictVector = (RepeatedDictVector)this.parentColumn.vector();
            DictVector dictVector = (DictVector)repeatedDictVector.getDataVector();
            if (this.isVersioned()) {
                dictVector.putChild(colSchema.name(), vector);
            }
            int index = this.outputSchema.addColumn(colSchema);
            assert (dictVector.size() == this.outputSchema.size());
            assert (dictVector.getField().getChildren().size() == this.outputSchema.size());
            return index;
        }

        @Override
        public AbstractTupleWriter writer() {
            return (AbstractTupleWriter)this.parentColumn.writer().array().dict().tuple();
        }
    }

    public static class SingleDictState
    extends DictState {
        public SingleDictState(LoaderInternals events, ResultVectorCache vectorCache, ProjectionFilter projectionSet) {
            super(events, vectorCache, projectionSet);
        }

        @Override
        public AbstractTupleWriter writer() {
            return (AbstractTupleWriter)this.parentColumn.writer().dict().tuple();
        }
    }

    public static class MapArrayState
    extends MapState {
        public MapArrayState(LoaderInternals events, ResultVectorCache vectorCache, ProjectionFilter projectionSet) {
            super(events, vectorCache, projectionSet);
        }

        @Override
        public AbstractTupleWriter writer() {
            return (AbstractTupleWriter)this.parentColumn.writer().array().tuple();
        }
    }

    public static class SingleMapState
    extends MapState {
        public SingleMapState(LoaderInternals events, ResultVectorCache vectorCache, ProjectionFilter projectionSet) {
            super(events, vectorCache, projectionSet);
        }

        @Override
        public AbstractTupleWriter writer() {
            return (AbstractTupleWriter)this.parentColumn.writer().tuple();
        }
    }

    public static class RowState
    extends TupleState {
        private final RowSetLoaderImpl writer;
        private final VectorContainer outputContainer;

        public RowState(ResultSetLoaderImpl rsLoader, ResultVectorCache vectorCache) {
            super(rsLoader, vectorCache, rsLoader.projectionSet());
            this.writer = new RowSetLoaderImpl(rsLoader, this.schema);
            this.writer.bindListener(this);
            this.outputContainer = new VectorContainer(rsLoader.allocator());
            this.outputSchema = new TupleSchema();
        }

        public RowSetLoaderImpl rootWriter() {
            return this.writer;
        }

        @Override
        public AbstractTupleWriter writer() {
            return this.writer;
        }

        @Override
        public int innerCardinality() {
            return this.loader.targetRowCount();
        }

        @Override
        protected boolean isVersioned() {
            return true;
        }

        @Override
        protected void updateOutput(int curSchemaVersion) {
            super.updateOutput(curSchemaVersion);
            this.outputContainer.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        }

        @Override
        public int addOutputColumn(ValueVector vector, ColumnMetadata colSchema) {
            this.outputContainer.add(vector);
            int index = this.outputSchema.addColumn(colSchema);
            assert (this.outputContainer.getNumberOfColumns() == this.outputSchema.size());
            return index;
        }

        public VectorContainer outputContainer() {
            return this.outputContainer;
        }
    }

    public static class MapVectorState
    implements VectorState {
        private final AbstractMapVector mapVector;
        private final VectorState offsets;

        public MapVectorState(AbstractMapVector mapVector, VectorState offsets) {
            this.mapVector = mapVector;
            this.offsets = offsets;
        }

        @Override
        public int allocate(int cardinality) {
            return this.offsets.allocate(cardinality);
        }

        @Override
        public void rollover(int cardinality) {
            this.offsets.rollover(cardinality);
        }

        @Override
        public void harvestWithLookAhead() {
            this.offsets.harvestWithLookAhead();
        }

        @Override
        public void startBatchWithLookAhead() {
            this.offsets.harvestWithLookAhead();
        }

        @Override
        public void close() {
            this.offsets.close();
        }

        public AbstractMapVector vector() {
            return this.mapVector;
        }

        public VectorState offsetVectorState() {
            return this.offsets;
        }

        @Override
        public boolean isProjected() {
            return this.offsets.isProjected();
        }

        @Override
        public void dump(HierarchicalFormatter format) {
            format.startObject(this).attribute("field", this.mapVector != null ? this.mapVector.getField() : "null").endObject();
        }
    }
}

