/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.EmptyErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.ResultVectorCache;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.physical.resultSet.impl.BuildFromSchema;
import org.apache.drill.exec.physical.resultSet.impl.ColumnBuilder;
import org.apache.drill.exec.physical.resultSet.impl.LoaderInternals;
import org.apache.drill.exec.physical.resultSet.impl.NullResultVectorCacheImpl;
import org.apache.drill.exec.physical.resultSet.impl.ProjectionFilter;
import org.apache.drill.exec.physical.resultSet.impl.ResultSetOptionBuilder;
import org.apache.drill.exec.physical.resultSet.impl.RowSetLoaderImpl;
import org.apache.drill.exec.physical.resultSet.impl.TupleState;
import org.apache.drill.exec.physical.resultSet.impl.WriterIndexImpl;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetLoaderImpl
implements ResultSetLoader,
LoaderInternals {
    protected static final Logger logger = LoggerFactory.getLogger(ResultSetLoaderImpl.class);
    private final ResultSetOptions options;
    private final BufferAllocator allocator;
    private final ColumnBuilder columnBuilder;
    private final TupleState.RowState rootState;
    private final WriterIndexImpl writerIndex;
    private final RowSetLoaderImpl rootWriter;
    private State state = State.START;
    private int activeSchemaVersion;
    private int harvestSchemaVersion;
    private int harvestBatchCount;
    private long previousRowCount;
    private int pendingRowCount;
    private int targetRowCount;
    private int batchSizeLimit;
    protected int accumulatedBatchSize;

    public ResultSetLoaderImpl(BufferAllocator allocator, ResultSetOptions options) {
        this.allocator = allocator;
        this.options = options;
        this.targetRowCount = options.rowCountLimit;
        this.writerIndex = new WriterIndexImpl(this);
        this.columnBuilder = new ColumnBuilder();
        ResultVectorCache vectorCache = options.vectorCache == null ? new NullResultVectorCacheImpl(allocator) : options.vectorCache;
        this.rootState = new TupleState.RowState(this, vectorCache);
        this.rootWriter = this.rootState.rootWriter();
        if (options.schema != null) {
            logger.debug("Schema: " + options.schema.toString());
            BuildFromSchema.instance().buildTuple(this.rootWriter, options.schema);
        }
        if (this.projectionSet().isEmpty()) {
            this.bumpVersion();
        }
    }

    public ProjectionFilter projectionSet() {
        return this.options.projectionSet;
    }

    private void updateCardinality() {
        this.rootState.updateCardinality();
    }

    public ResultSetLoaderImpl(BufferAllocator allocator) {
        this(allocator, new ResultSetOptions());
    }

    @Override
    public BufferAllocator allocator() {
        return this.allocator;
    }

    @Override
    public int bumpVersion() {
        ++this.activeSchemaVersion;
        switch (this.state) {
            case HARVESTED: 
            case START: 
            case LOOK_AHEAD: {
                this.harvestSchemaVersion = this.activeSchemaVersion;
                break;
            }
        }
        return this.activeSchemaVersion;
    }

    @Override
    public int activeSchemaVersion() {
        return this.activeSchemaVersion;
    }

    @Override
    public int schemaVersion() {
        switch (this.state) {
            case ACTIVE: 
            case IN_OVERFLOW: 
            case OVERFLOW: 
            case FULL_BATCH: {
                return this.activeSchemaVersion;
            }
            case HARVESTED: 
            case START: 
            case LOOK_AHEAD: 
            case LIMITED: {
                return this.harvestSchemaVersion;
            }
        }
        throw new IllegalStateException("Unexpected state: " + (Object)((Object)this.state));
    }

    @Override
    public boolean startBatch() {
        return this.startBatch(false);
    }

    public boolean startEmptyBatch() {
        return this.startBatch(true);
    }

    public boolean startBatch(boolean schemaOnly) {
        switch (this.state) {
            case HARVESTED: 
            case START: {
                logger.trace("Start batch");
                this.accumulatedBatchSize = 0;
                this.updateCardinality();
                this.rootState.startBatch(schemaOnly);
                this.checkInitialAllocation();
                this.writerIndex.reset();
                this.rootWriter.startWrite();
                break;
            }
            case LOOK_AHEAD: {
                logger.trace("Start batch after overflow");
                this.rootState.startBatch(schemaOnly);
                break;
            }
            case LIMITED: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unexpected state: " + (Object)((Object)this.state));
            }
        }
        this.harvestSchemaVersion = this.activeSchemaVersion;
        this.pendingRowCount = 0;
        this.batchSizeLimit = (int)Math.min((long)this.targetRowCount, this.options.scanLimit - this.totalRowCount());
        this.state = State.ACTIVE;
        return true;
    }

    @Override
    public boolean hasRows() {
        switch (this.state) {
            case HARVESTED: 
            case ACTIVE: 
            case FULL_BATCH: {
                return this.rootWriter.rowCount() > 0;
            }
            case LOOK_AHEAD: {
                return true;
            }
        }
        return false;
    }

    @Override
    public RowSetLoader writer() {
        if (this.state == State.CLOSED) {
            throw new IllegalStateException("Unexpected state: " + (Object)((Object)this.state));
        }
        return this.rootWriter;
    }

    @Override
    public ResultSetLoader setRow(Object ... values) {
        this.startRow();
        this.writer().setObject(values);
        this.saveRow();
        return this;
    }

    protected void startRow() {
        switch (this.state) {
            case ACTIVE: {
                this.harvestSchemaVersion = this.activeSchemaVersion;
                this.rootWriter.startRow();
                break;
            }
            case LIMITED: {
                throw new IllegalStateException("Attempt to write past the scan limit.");
            }
            default: {
                throw new IllegalStateException("Unexpected state: " + (Object)((Object)this.state));
            }
        }
    }

    protected void saveRow() {
        switch (this.state) {
            case ACTIVE: {
                this.rootWriter.endArrayValue();
                this.rootWriter.saveRow();
                if (!this.writerIndex.next()) {
                    this.state = State.FULL_BATCH;
                }
                this.harvestSchemaVersion = this.activeSchemaVersion;
                break;
            }
            case OVERFLOW: {
                this.rootWriter.endArrayValue();
                this.rootWriter.saveRow();
                this.writerIndex.next();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state: " + (Object)((Object)this.state));
            }
        }
    }

    protected boolean isFull() {
        switch (this.state) {
            case ACTIVE: {
                return !this.writerIndex.valid();
            }
            case OVERFLOW: 
            case FULL_BATCH: {
                return true;
            }
            case LIMITED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean writeable() {
        return (this.state == State.ACTIVE || this.state == State.OVERFLOW) && !this.atLimit();
    }

    private boolean isBatchActive() {
        return this.state == State.ACTIVE || this.state == State.OVERFLOW || this.state == State.FULL_BATCH;
    }

    protected int rowCount() {
        switch (this.state) {
            case ACTIVE: 
            case FULL_BATCH: {
                return this.writerIndex.size();
            }
            case OVERFLOW: {
                return this.pendingRowCount;
            }
        }
        return 0;
    }

    protected WriterIndexImpl writerIndex() {
        return this.writerIndex;
    }

    @Override
    public void setTargetRowCount(int rowCount) {
        this.targetRowCount = Math.min(Math.max(1, rowCount), 65536);
    }

    @Override
    public int targetRowCount() {
        return this.targetRowCount;
    }

    @Override
    public int targetVectorSize() {
        return this.options.vectorSizeLimit;
    }

    @Override
    public int maxBatchSize() {
        return this.batchSizeLimit;
    }

    @Override
    public int skipRows(int requestedCount) {
        if (this.state != State.ACTIVE) {
            throw new IllegalStateException("No batch is active.");
        }
        return this.writerIndex.skipRows(requestedCount);
    }

    @Override
    public boolean isProjectionEmpty() {
        return !this.rootState.hasProjections();
    }

    @Override
    public void overflowed() {
        logger.trace("Vector overflow");
        if (this.state == State.OVERFLOW) {
            throw UserException.memoryError("A single column value is larger than the maximum allowed size of 16 MB", new Object[0]).build(logger);
        }
        if (this.state != State.ACTIVE) {
            throw new IllegalStateException("Unexpected state: " + (Object)((Object)this.state));
        }
        this.state = State.IN_OVERFLOW;
        this.pendingRowCount = this.writerIndex.vectorIndex();
        this.updateCardinality();
        this.rootWriter.preRollover();
        this.accumulatedBatchSize = 0;
        this.rootState.rollover();
        this.rootWriter.postRollover();
        this.writerIndex.rollover();
        this.checkInitialAllocation();
        this.state = State.OVERFLOW;
    }

    @Override
    public boolean hasOverflow() {
        return this.state == State.OVERFLOW;
    }

    @Override
    public VectorContainer outputContainer() {
        return this.rootState.outputContainer();
    }

    @Override
    public VectorContainer harvest() {
        int rowCount;
        switch (this.state) {
            case ACTIVE: 
            case FULL_BATCH: {
                rowCount = this.harvestNormalBatch();
                logger.trace("Harvesting {} rows", (Object)rowCount);
                break;
            }
            case OVERFLOW: {
                rowCount = this.harvestOverflowBatch();
                logger.trace("Harvesting {} rows after overflow", (Object)rowCount);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state: " + (Object)((Object)this.state));
            }
        }
        this.rootState.updateOutput(this.harvestSchemaVersion);
        VectorContainer container = this.rootState.outputContainer();
        container.setRecordCount(rowCount);
        ++this.harvestBatchCount;
        this.previousRowCount += (long)rowCount;
        if (this.atLimit()) {
            this.state = State.LIMITED;
        }
        return container;
    }

    private int harvestNormalBatch() {
        this.rootWriter.endBatch();
        this.harvestSchemaVersion = this.activeSchemaVersion;
        this.state = State.HARVESTED;
        return this.writerIndex.size();
    }

    private int harvestOverflowBatch() {
        this.rootState.harvestWithLookAhead();
        this.state = State.LOOK_AHEAD;
        return this.pendingRowCount;
    }

    @Override
    public boolean atLimit() {
        switch (this.state) {
            case LIMITED: {
                return true;
            }
            case HARVESTED: 
            case ACTIVE: {
                return this.totalRowCount() >= this.options.scanLimit;
            }
        }
        return false;
    }

    @Override
    public TupleMetadata outputSchema() {
        return this.rootState.outputSchema();
    }

    @Override
    public TupleMetadata activeSchema() {
        return this.rootState.schema();
    }

    @Override
    public void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        this.rootState.close();
        this.state = State.CLOSED;
    }

    @Override
    public int batchCount() {
        return this.harvestBatchCount + (this.rowCount() == 0 ? 0 : 1);
    }

    @Override
    public long totalRowCount() {
        long total = this.previousRowCount;
        if (this.isBatchActive()) {
            total += (long)(this.pendingRowCount + this.writerIndex.size());
        }
        return total;
    }

    public TupleState.RowState rootState() {
        return this.rootState;
    }

    @Override
    public boolean canExpand(int delta) {
        this.accumulatedBatchSize += delta;
        return this.state == State.IN_OVERFLOW || this.options.maxBatchSize <= 0L || (long)this.accumulatedBatchSize <= this.options.maxBatchSize;
    }

    @Override
    public void tallyAllocations(int allocationBytes) {
        this.accumulatedBatchSize += allocationBytes;
    }

    private void checkInitialAllocation() {
        if (this.options.maxBatchSize < 0L) {
            logger.debug("Initial vector allocation: {}, no batch limit specified", (Object)this.accumulatedBatchSize);
        } else if ((long)this.accumulatedBatchSize > this.options.maxBatchSize) {
            logger.warn("Initial vector allocation: {}, but batch size limit is: {}", (Object)this.accumulatedBatchSize, (Object)this.options.maxBatchSize);
        } else {
            logger.debug("Initial vector allocation: {}, batch size limit: {}", (Object)this.accumulatedBatchSize, (Object)this.options.maxBatchSize);
        }
    }

    public void dump(HierarchicalFormatter format) {
        format.startObject(this).attribute("options");
        this.options.dump(format);
        format.attribute("index", this.writerIndex.vectorIndex()).attribute("state", (Object)this.state).attribute("activeSchemaVersion", this.activeSchemaVersion).attribute("harvestSchemaVersion", this.harvestSchemaVersion).attribute("pendingRowCount", this.pendingRowCount).attribute("targetRowCount", this.targetRowCount);
        format.attribute("root");
        this.rootState.dump(format);
        format.attribute("rootWriter");
        this.rootWriter.dump(format);
        format.endObject();
    }

    @Override
    public ResultVectorCache vectorCache() {
        return this.rootState.vectorCache();
    }

    @Override
    public int rowIndex() {
        return this.writerIndex().vectorIndex();
    }

    @Override
    public ColumnBuilder columnBuilder() {
        return this.columnBuilder;
    }

    @Override
    public CustomErrorContext errorContext() {
        return this.options.errorContext;
    }

    private static enum State {
        START,
        ACTIVE,
        OVERFLOW,
        IN_OVERFLOW,
        FULL_BATCH,
        HARVESTED,
        LOOK_AHEAD,
        LIMITED,
        CLOSED;

    }

    public static class ResultSetOptions {
        protected final int vectorSizeLimit;
        protected final int rowCountLimit;
        protected final ResultVectorCache vectorCache;
        protected final ProjectionFilter projectionSet;
        protected final TupleMetadata schema;
        protected final long maxBatchSize;
        protected final long scanLimit;
        protected final CustomErrorContext errorContext;

        public ResultSetOptions() {
            this.vectorSizeLimit = ValueVector.MAX_BUFFER_SIZE;
            this.rowCountLimit = 4096;
            this.projectionSet = ProjectionFilter.PROJECT_ALL;
            this.vectorCache = null;
            this.schema = null;
            this.maxBatchSize = -1L;
            this.errorContext = null;
            this.scanLimit = Long.MAX_VALUE;
        }

        public ResultSetOptions(ResultSetOptionBuilder builder) {
            this.vectorSizeLimit = builder.vectorSizeLimit;
            this.rowCountLimit = builder.rowCountLimit;
            this.vectorCache = builder.vectorCache;
            this.schema = builder.readerSchema;
            this.maxBatchSize = builder.maxBatchSize;
            this.scanLimit = builder.scanLimit;
            CustomErrorContext customErrorContext = this.errorContext = builder.errorContext == null ? EmptyErrorContext.INSTANCE : builder.errorContext;
            this.projectionSet = builder.projectionFilter != null ? builder.projectionFilter : (builder.projectionSet != null ? ProjectionFilter.projectionFilter(builder.projectionSet, this.errorContext) : ProjectionFilter.PROJECT_ALL);
            if (this.schema != null && MetadataUtils.hasDynamicColumns(this.schema)) {
                throw UserException.validationError().message("Reader input schema must not contain dynamic columns", new Object[0]).addContext(this.errorContext).build(logger);
            }
        }

        public void dump(HierarchicalFormatter format) {
            format.startObject(this).attribute("vectorSizeLimit", this.vectorSizeLimit).attribute("rowCountLimit", this.rowCountLimit).endObject();
        }
    }
}

