/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import org.apache.drill.exec.physical.resultSet.impl.SingleVectorState;
import org.apache.drill.exec.physical.resultSet.impl.VectorState;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.ArrayWriter;
import org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import org.apache.drill.exec.vector.accessor.writer.AbstractArrayWriter;
import org.apache.drill.exec.vector.accessor.writer.AbstractScalarWriterImpl;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;

public class RepeatedVectorState
implements VectorState {
    private final AbstractArrayWriter arrayWriter;
    private final RepeatedValueVector vector;
    private final SingleVectorState.OffsetVectorState offsetsState;
    private final SingleVectorState.SimpleVectorState valuesState;

    public RepeatedVectorState(ArrayWriter writer, RepeatedValueVector vector) {
        this.vector = vector;
        this.arrayWriter = (AbstractArrayWriter)writer;
        AbstractScalarWriterImpl colWriter = (AbstractScalarWriterImpl)writer.entry().events();
        this.valuesState = SingleVectorState.SimpleVectorState.vectorState(writer.schema(), colWriter, vector.getDataVector());
        this.offsetsState = new SingleVectorState.OffsetVectorState(this.arrayWriter.offsetWriter(), vector.getOffsetVector(), colWriter);
    }

    @Override
    public <T extends ValueVector> T vector() {
        return (T)this.vector;
    }

    @Override
    public int allocate(int cardinality) {
        return this.offsetsState.allocate(cardinality) + this.valuesState.allocate(this.childCardinality(cardinality));
    }

    private int childCardinality(int cardinality) {
        return cardinality * this.arrayWriter.schema().expectedElementCount();
    }

    @Override
    public void rollover(int newCardinality) {
        this.valuesState.rollover(this.childCardinality(newCardinality));
        this.offsetsState.rollover(newCardinality);
    }

    @Override
    public void harvestWithLookAhead() {
        this.offsetsState.harvestWithLookAhead();
        this.valuesState.harvestWithLookAhead();
    }

    @Override
    public void startBatchWithLookAhead() {
        this.offsetsState.startBatchWithLookAhead();
        this.valuesState.startBatchWithLookAhead();
    }

    @Override
    public void close() {
        this.offsetsState.close();
        this.valuesState.close();
    }

    @Override
    public boolean isProjected() {
        return true;
    }

    @Override
    public void dump(HierarchicalFormatter format) {
        format.startObject(this).attribute("schema", this.arrayWriter.schema()).attributeIdentity("writer", this.arrayWriter).attributeIdentity("vector", this.vector).attribute("offsetsState");
        this.offsetsState.dump(format);
        format.attribute("valuesState");
        this.valuesState.dump(format);
        format.endObject();
    }
}

