/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.drill.exec.physical.resultSet.ResultVectorCache;
import org.apache.drill.exec.physical.resultSet.impl.ColumnState;
import org.apache.drill.exec.physical.resultSet.impl.ContainerState;
import org.apache.drill.exec.physical.resultSet.impl.LoaderInternals;
import org.apache.drill.exec.physical.resultSet.impl.NullVectorState;
import org.apache.drill.exec.physical.resultSet.impl.ProjectionFilter;
import org.apache.drill.exec.physical.resultSet.impl.SingleVectorState;
import org.apache.drill.exec.physical.resultSet.impl.VectorState;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.RepeatedListColumnMetadata;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.ArrayWriter;
import org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import org.apache.drill.exec.vector.accessor.writer.RepeatedListWriter;
import org.apache.drill.exec.vector.complex.RepeatedListVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class RepeatedListState
extends ContainerState
implements RepeatedListWriter.ArrayListener {
    private ColumnState childState;

    public RepeatedListState(LoaderInternals loader, ResultVectorCache vectorCache) {
        super(loader, vectorCache, ProjectionFilter.PROJECT_ALL);
    }

    @Override
    public int innerCardinality() {
        return this.parentColumn.innerCardinality();
    }

    @Override
    protected void addColumn(ColumnState colState) {
        assert (this.childState == null);
        this.childState = colState;
        ((RepeatedListColumnMetadata)this.parentColumn.schema()).childSchema(colState.schema());
        RepeatedListVectorState vectorState = (RepeatedListVectorState)this.parentColumn.vectorState();
        RepeatedListVector listVector = vectorState.vector;
        if (listVector != null) {
            listVector.setChildVector((ValueVector)this.childState.vector());
        }
        vectorState.updateChildWriter(this.childState.writer());
    }

    @Override
    protected Collection<ColumnState> columnStates() {
        if (this.childState == null) {
            return new ArrayList<ColumnState>();
        }
        return Lists.newArrayList(this.childState);
    }

    @Override
    protected boolean isVersioned() {
        return false;
    }

    @Override
    public AbstractObjectWriter setChild(ArrayWriter array, ColumnMetadata columnSchema) {
        assert (this.childState == null);
        return this.addColumn(columnSchema).writer();
    }

    @Override
    public AbstractObjectWriter setChild(ArrayWriter array, MaterializedField field) {
        return this.setChild(array, MetadataUtils.fromField(field));
    }

    public static class RepeatedListVectorState
    implements VectorState {
        private final ArrayWriter arrayWriter;
        private final RepeatedListVector vector;
        private final VectorState offsetsState;

        public RepeatedListVectorState(AbstractObjectWriter arrayWriter, RepeatedListVector vector) {
            this.vector = vector;
            this.arrayWriter = arrayWriter.array();
            this.offsetsState = vector == null ? new NullVectorState() : new SingleVectorState.OffsetVectorState(arrayWriter.events(), vector.getOffsetVector(), this.arrayWriter.entryType() == null ? null : arrayWriter.events());
        }

        public void updateChildWriter(AbstractObjectWriter childWriter) {
            if (this.offsetsState instanceof SingleVectorState.OffsetVectorState) {
                ((SingleVectorState.OffsetVectorState)this.offsetsState).setChildWriter(childWriter.events());
            }
        }

        public RepeatedListVector vector() {
            return this.vector;
        }

        @Override
        public int allocate(int cardinality) {
            return this.offsetsState.allocate(cardinality);
        }

        @Override
        public void rollover(int cardinality) {
            this.offsetsState.rollover(cardinality);
        }

        @Override
        public void harvestWithLookAhead() {
            this.offsetsState.harvestWithLookAhead();
        }

        @Override
        public void startBatchWithLookAhead() {
            this.offsetsState.startBatchWithLookAhead();
        }

        @Override
        public void close() {
            this.offsetsState.close();
        }

        @Override
        public boolean isProjected() {
            return true;
        }

        @Override
        public void dump(HierarchicalFormatter format) {
            format.startObject(this).attribute("schema", this.arrayWriter.schema()).attributeIdentity("writer", this.arrayWriter).attributeIdentity("vector", this.vector).attribute("offsetsState");
            this.offsetsState.dump(format);
            format.endObject();
        }
    }

    public static class RepeatedListColumnState
    extends ColumnState.BaseContainerColumnState {
        private final ContainerState listState;

        public RepeatedListColumnState(LoaderInternals loader, AbstractObjectWriter writer, VectorState vectorState, ContainerState listState) {
            super(loader, writer, vectorState);
            this.listState = listState;
            listState.bindColumnState(this);
        }

        @Override
        public ColumnMetadata outputSchema() {
            return this.schema();
        }

        @Override
        public ContainerState container() {
            return this.listState;
        }
    }
}

