/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import org.apache.drill.exec.physical.resultSet.PushResultSetReader;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.IndirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetReader;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class PushResultSetReaderImpl
implements PushResultSetReader {
    private final UpstreamSource source;
    private int priorSchemaVersion;
    private RowSetReader rowSetReader;

    public PushResultSetReaderImpl(UpstreamSource source) {
        this.source = source;
    }

    @Override
    public RowSetReader start() {
        boolean newSchema;
        int sourceSchemaVersion = this.source.schemaVersion();
        Preconditions.checkState(sourceSchemaVersion > 0);
        Preconditions.checkState(this.priorSchemaVersion <= sourceSchemaVersion);
        boolean bl = newSchema = this.priorSchemaVersion != sourceSchemaVersion;
        if (newSchema) {
            this.rowSetReader = this.createRowSet().reader();
            this.priorSchemaVersion = sourceSchemaVersion;
        } else {
            this.rowSetReader.newBatch();
        }
        return this.rowSetReader;
    }

    private RowSet createRowSet() {
        VectorContainer container = this.source.batch();
        switch (container.getSchema().getSelectionVectorMode()) {
            case FOUR_BYTE: {
                throw new IllegalArgumentException("Build from SV4 not yet supported");
            }
            case NONE: {
                return DirectRowSet.fromContainer(container);
            }
            case TWO_BYTE: {
                return IndirectRowSet.fromSv2(container, this.source.sv2());
            }
        }
        throw new IllegalStateException("Invalid selection mode");
    }

    public static interface UpstreamSource {
        public int schemaVersion();

        public VectorContainer batch();

        public SelectionVector2 sv2();
    }

    public static class BatchHolder
    implements UpstreamSource {
        private final VectorContainer container;
        private int schemaVersion;

        public BatchHolder(VectorContainer container) {
            this.container = container;
        }

        public void newBatch() {
            if (this.schemaVersion == 0) {
                this.schemaVersion = 1;
            } else if (this.container.isSchemaChanged()) {
                ++this.schemaVersion;
            }
        }

        @Override
        public int schemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public VectorContainer batch() {
            return this.container;
        }

        @Override
        public SelectionVector2 sv2() {
            return null;
        }
    }
}

