/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import org.apache.drill.exec.physical.resultSet.impl.SingleVectorState;
import org.apache.drill.exec.physical.resultSet.impl.VectorState;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.vector.NullableVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import org.apache.drill.exec.vector.accessor.writer.NullableScalarWriter;

public class NullableVectorState
implements VectorState {
    private final ColumnMetadata schema;
    private final NullableScalarWriter writer;
    private final NullableVector vector;
    private final VectorState bitsState;
    private final VectorState valuesState;

    public NullableVectorState(AbstractObjectWriter writer, NullableVector vector) {
        this.schema = writer.schema();
        this.vector = vector;
        this.writer = (NullableScalarWriter)writer.events();
        this.bitsState = new SingleVectorState.IsSetVectorState(this.writer.bitsWriter(), vector.getBitsVector());
        this.valuesState = SingleVectorState.SimpleVectorState.vectorState(this.writer.schema(), this.writer.baseWriter(), vector.getValuesVector());
    }

    @Override
    public int allocate(int cardinality) {
        return this.bitsState.allocate(cardinality) + this.valuesState.allocate(cardinality);
    }

    @Override
    public void rollover(int cardinality) {
        this.bitsState.rollover(cardinality);
        this.valuesState.rollover(cardinality);
    }

    @Override
    public void harvestWithLookAhead() {
        this.bitsState.harvestWithLookAhead();
        this.valuesState.harvestWithLookAhead();
    }

    @Override
    public void startBatchWithLookAhead() {
        this.bitsState.startBatchWithLookAhead();
        this.valuesState.startBatchWithLookAhead();
    }

    @Override
    public void close() {
        this.bitsState.close();
        this.valuesState.close();
    }

    @Override
    public <T extends ValueVector> T vector() {
        return (T)this.vector;
    }

    @Override
    public boolean isProjected() {
        return true;
    }

    @Override
    public void dump(HierarchicalFormatter format) {
        format.startObject(this).attribute("schema", this.schema).attributeIdentity("writer", this.writer).attributeIdentity("vector", this.vector).attribute("bitsState");
        this.bitsState.dump(format);
        format.attribute("valuesState");
        this.valuesState.dump(format);
        format.endObject();
    }
}

