/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.resultSet.impl.ContainerState;
import org.apache.drill.exec.physical.resultSet.impl.LoaderInternals;
import org.apache.drill.exec.physical.resultSet.impl.TupleState;
import org.apache.drill.exec.physical.resultSet.impl.VectorState;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.ObjectType;
import org.apache.drill.exec.vector.accessor.ScalarWriter;
import org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import org.apache.drill.exec.vector.accessor.writer.WriterEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ColumnState {
    private static final Logger logger = LoggerFactory.getLogger(ColumnState.class);
    protected final LoaderInternals loader;
    protected final int addVersion;
    protected final VectorState vectorState;
    protected State state;
    protected AbstractObjectWriter writer;
    protected int cardinality;
    protected int outputIndex = -1;

    public ColumnState(LoaderInternals loader, AbstractObjectWriter writer, VectorState vectorState) {
        this.loader = loader;
        this.vectorState = vectorState;
        this.addVersion = writer.isProjected() ? loader.bumpVersion() : loader.activeSchemaVersion();
        this.state = loader.hasOverflow() ? State.NEW_LOOK_AHEAD : State.NORMAL;
        this.writer = writer;
    }

    public AbstractObjectWriter writer() {
        return this.writer;
    }

    public ColumnMetadata schema() {
        return this.writer.schema();
    }

    public VectorState vectorState() {
        return this.vectorState;
    }

    public <T extends ValueVector> T vector() {
        return this.vectorState.vector();
    }

    public void allocateVectors() {
        assert (this.cardinality != 0);
        this.loader.tallyAllocations(this.vectorState.allocate(this.cardinality));
    }

    public void startBatch(boolean schemaOnly) {
        switch (this.state) {
            case NORMAL: {
                if (schemaOnly) break;
                this.allocateVectors();
                break;
            }
            case NEW_LOOK_AHEAD: {
                break;
            }
            case LOOK_AHEAD: {
                this.vectorState.startBatchWithLookAhead();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state: " + (Object)((Object)this.state));
            }
        }
        this.state = State.NORMAL;
    }

    public void rollover() {
        assert (this.state == State.NORMAL);
        if (this.loader.rowIndex() == 0) {
            throw UserException.memoryError("A single column value is larger than the maximum allowed size of 16 MB", new Object[0]).build(logger);
        }
        this.vectorState.rollover(this.cardinality);
        this.state = State.OVERFLOW;
    }

    public void harvestWithLookAhead() {
        switch (this.state) {
            case NEW_LOOK_AHEAD: {
                break;
            }
            case OVERFLOW: {
                this.vectorState.harvestWithLookAhead();
                this.state = State.LOOK_AHEAD;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state: " + (Object)((Object)this.state));
            }
        }
    }

    public boolean isProjected() {
        return this.vectorState.isProjected();
    }

    public void updateCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public int outerCardinality() {
        return this.cardinality;
    }

    public int innerCardinality() {
        ColumnMetadata schema = this.schema();
        if (schema.isArray()) {
            int elementCount = Math.max(1, schema.expectedElementCount());
            return Math.min(65536, this.cardinality * elementCount);
        }
        return this.cardinality;
    }

    public void buildOutput(TupleState tupleState) {
        this.outputIndex = tupleState.addOutputColumn((ValueVector)this.vector(), this.outputSchema());
    }

    public abstract ColumnMetadata outputSchema();

    public void close() {
        this.vectorState.close();
    }

    public void dump(HierarchicalFormatter format) {
        format.startObject(this).attribute("addVersion", this.addVersion).attribute("state", (Object)this.state).attributeIdentity("writer", this.writer).attribute("vectorState");
        this.vectorState.dump(format);
        format.endObject();
    }

    protected static enum State {
        NORMAL,
        OVERFLOW,
        LOOK_AHEAD,
        NEW_LOOK_AHEAD;

    }

    public static abstract class BaseContainerColumnState
    extends ColumnState {
        public BaseContainerColumnState(LoaderInternals loader, AbstractObjectWriter writer, VectorState vectorState) {
            super(loader, writer, vectorState);
        }

        public abstract ContainerState container();

        @Override
        public void updateCardinality(int cardinality) {
            super.updateCardinality(cardinality);
            this.container().updateCardinality();
        }

        @Override
        public void startBatch(boolean schemaOnly) {
            super.startBatch(schemaOnly);
            this.container().startBatch(schemaOnly);
        }

        @Override
        public void rollover() {
            super.rollover();
            this.container().rollover();
        }

        @Override
        public void harvestWithLookAhead() {
            super.harvestWithLookAhead();
            this.container().harvestWithLookAhead();
        }

        @Override
        public void close() {
            super.close();
            this.container().close();
        }
    }

    public static class PrimitiveColumnState
    extends ColumnState
    implements WriterEvents.ColumnWriterListener {
        public PrimitiveColumnState(LoaderInternals loader, AbstractObjectWriter colWriter, VectorState vectorState) {
            super(loader, colWriter, vectorState);
            WriterEvents scalarEvents = colWriter.type() == ObjectType.ARRAY ? this.writer.array().entry().events() : this.writer.events();
            scalarEvents.bindListener(this);
        }

        @Override
        public boolean canExpand(ScalarWriter writer, int delta) {
            return this.loader.canExpand(delta);
        }

        @Override
        public void overflowed(ScalarWriter writer) {
            this.loader.overflowed();
        }

        @Override
        public ColumnMetadata outputSchema() {
            return this.schema();
        }

        @Override
        public void dump(HierarchicalFormatter format) {
        }
    }
}

